/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.Collections;
import java.util.List;

public abstract class AbstractHealthCheckEnricher
extends BaseEnricher {
    public AbstractHealthCheckEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    @Override
    public void addMissingResources(KubernetesListBuilder builder) {
        List items = builder.getItems();
        for (HasMetadata item : items) {
            if (!(item instanceof Deployment)) continue;
            Deployment deployment = (Deployment)item;
            List<Container> containers = this.getCandidateContainers(deployment);
            for (Container container : containers) {
                Probe probe;
                if (container.getReadinessProbe() == null && (probe = this.getReadinessProbe()) != null) {
                    this.log.info("Adding readiness " + this.describe(probe), new Object[0]);
                    container.setReadinessProbe(probe);
                }
                if (container.getLivenessProbe() != null || (probe = this.getLivenessProbe()) == null) continue;
                this.log.info("Adding liveness " + this.describe(probe), new Object[0]);
                container.setLivenessProbe(probe);
            }
        }
        builder.withItems(items);
    }

    private List<Container> getCandidateContainers(Deployment deployment) {
        List containers;
        if (deployment.getSpec() != null && deployment.getSpec().getTemplate() != null && deployment.getSpec().getTemplate().getSpec() != null && deployment.getSpec().getTemplate().getSpec().getContainers() != null && deployment.getSpec().getTemplate().getSpec().getContainers().size() > 0 && (containers = deployment.getSpec().getTemplate().getSpec().getContainers()) != null && containers.size() > 0) {
            return Collections.singletonList(containers.get(containers.size() - 1));
        }
        return Collections.emptyList();
    }

    private String describe(Probe probe) {
        StringBuilder desc = new StringBuilder("probe");
        if (probe.getHttpGet() != null) {
            desc.append(" on port ");
            desc.append(probe.getHttpGet().getPort().getIntVal());
            desc.append(", path='");
            desc.append(probe.getHttpGet().getPath());
            desc.append("'");
        }
        if (probe.getInitialDelaySeconds() != null) {
            desc.append(", with initial delay ");
            desc.append(probe.getInitialDelaySeconds());
            desc.append(" seconds");
        }
        if (probe.getPeriodSeconds() != null) {
            desc.append(", with period ");
            desc.append(probe.getPeriodSeconds());
            desc.append(" seconds");
        }
        return desc.toString();
    }

    protected abstract Probe getReadinessProbe();

    protected abstract Probe getLivenessProbe();
}

