/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class EnricherContext {
    private final MavenProject project;
    private final Logger log;
    private final List<ImageConfiguration> images;
    private final ResourceConfig resourceConfig;
    private ProcessorConfig config;
    private boolean useProjectClasspath;
    private final MavenSession session;
    private final GoalFinder goalFinder;

    public EnricherContext(MavenProject project, MavenSession session, GoalFinder goalFinder, ProcessorConfig enricherConfig, List<ImageConfiguration> images, ResourceConfig kubernetesConfig, Logger log, boolean useProjectClasspath) {
        this.session = session;
        this.goalFinder = goalFinder;
        this.log = log;
        this.project = project;
        this.config = enricherConfig;
        this.images = images;
        this.resourceConfig = kubernetesConfig;
        this.useProjectClasspath = useProjectClasspath;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<ImageConfiguration> getImages() {
        return this.images;
    }

    public Logger getLog() {
        return this.log;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public boolean runningWithGoal(String ... goals) throws MojoExecutionException {
        for (String goal : goals) {
            if (!this.goalFinder.runningWithGoal(this.project, this.session, goal)) continue;
            return true;
        }
        return false;
    }
}

