/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api.Util;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.utils.GitHelpers;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitUtil {
    public static Repository getGitRepository(MavenProject project) throws IOException {
        File gitFolder;
        MavenProject rootProject = MavenUtil.getRootProject((MavenProject)project);
        File baseDir = rootProject.getBasedir();
        if (baseDir == null) {
            baseDir = project.getBasedir();
        }
        if (baseDir == null) {
            baseDir = new File(System.getProperty("basedir", "."));
        }
        if ((gitFolder = GitHelpers.findGitFolder((File)baseDir)) == null) {
            return null;
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
        return repository;
    }

    public static String getGitCommitId(Repository repository) throws GitAPIException {
        Iterable logs;
        Iterator iterator;
        if (repository != null && (iterator = (logs = new Git(repository).log().call()).iterator()).hasNext()) {
            RevCommit rev = (RevCommit)iterator.next();
            return rev.getName();
        }
        return null;
    }
}

