/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.Configs;
import java.util.Properties;

public class EnricherConfig {
    private static final String ENRICHER_PROP_PREFIX = "fabri8.enricher";
    private final String name;
    private final ProcessorConfig config;
    private final Properties projectProperties;

    public EnricherConfig(Properties projectProperties, String name, ProcessorConfig config) {
        this.config = config != null ? config : ProcessorConfig.EMPTY;
        this.name = name;
        this.projectProperties = projectProperties;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public String get(Configs.Key key, String defaultVal) {
        String fullKey;
        String val = this.config.getConfig(this.name, key.name());
        if (val == null && (val = this.projectProperties.getProperty(fullKey = "fabri8.enricher." + this.name + "." + key)) == null) {
            val = System.getProperty(fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

