/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.Configs;
import java.util.Properties;
import org.apache.maven.shared.utils.StringUtils;

public class EnricherConfig {
    private static final String ENRICHER_PROP_PREFIX = "fabri8.enricher";
    private final String prefix;
    private final ProcessorConfig config;
    private final Properties projectProperties;

    public EnricherConfig(Properties projectProperties, String prefix, ProcessorConfig config) {
        this.config = config != null ? config : ProcessorConfig.EMPTY;
        this.prefix = prefix;
        this.projectProperties = projectProperties;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public String get(Configs.Key key, String defaultVal) {
        String keyVal = key != null ? key.name() : "";
        String fullKey = this.prefix + (StringUtils.isNotEmpty((String)keyVal) ? "." + key : "");
        String val = this.config.getConfig(fullKey);
        if (val == null) {
            val = this.projectProperties.getProperty("fabri8.enricher." + fullKey);
        }
        if (val == null) {
            val = System.getProperty("fabri8.enricher." + fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

