/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.shared.utils.StringUtils;

public class EnricherConfiguration {
    private final String prefix;
    private final Map<String, String> config;

    public EnricherConfiguration(String prefix, Map<String, String> config) {
        this.config = Collections.unmodifiableMap(config != null ? config : Collections.emptyMap());
        this.prefix = prefix;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultVal) {
        String val = this.config.get(this.prefix + (StringUtils.isNotEmpty((String)key) ? "." + key : ""));
        return val != null ? val : defaultVal;
    }

    public int getAsInt(String key) {
        return this.getAsInt(key, 0);
    }

    public int getAsInt(String key, int defaultVal) {
        String val = this.get(key);
        return val != null ? Integer.parseInt(val) : defaultVal;
    }

    public boolean getAsBoolean(String key) {
        return this.getAsBoolean(key, false);
    }

    public boolean getAsBoolean(String key, boolean defaultVal) {
        String val = this.get(key);
        return val != null ? Boolean.parseBoolean(val) : defaultVal;
    }
}

