/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.utils.Strings;
import java.net.ConnectException;
import java.util.Stack;

public abstract class AbstractLiveEnricher
extends BaseEnricher {
    private KubernetesClient kubernetesClient;

    public AbstractLiveEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    protected boolean isOnline() {
        return Configs.asBoolean((String)this.getConfig(Config.online)) || this.asBooleanFromGlobalProp("fabric8.online");
    }

    protected String getExternalServiceURL(String serviceName, String protocol) {
        Object publicUrl = null;
        if (!this.isOnline()) {
            this.getLog().info("Not looking for service " + serviceName + " as we are in offline mode");
            return null;
        }
        try {
            KubernetesClient kubernetes = this.getKubernetes();
            String ns = kubernetes.getNamespace();
            Service service = (Service)((ClientResource)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(ns)).withName(serviceName)).get();
            return service != null ? KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)serviceName, (String)ns, (String)protocol, (boolean)true) : null;
        }
        catch (Throwable e) {
            Throwable cause = e;
            boolean notFound = false;
            boolean connectError = false;
            Stack<Throwable> stack = this.unfoldExceptions(e);
            while (!stack.isEmpty()) {
                Throwable t = stack.pop();
                if (t instanceof ConnectException || "No route to host".equals(t.getMessage())) {
                    this.getLog().warn("Cannot connect to Kubernetes to find URL for service %s : %s", new Object[]{serviceName, cause.getMessage()});
                    return null;
                }
                if (!(t instanceof IllegalArgumentException) && (t.getMessage() == null || !t.getMessage().matches("^No.*found.*$"))) continue;
                this.getLog().warn(cause.getMessage());
                return null;
            }
            this.getLog().warn("Cannot find URL for service %s : %s", new Object[]{serviceName, cause.getMessage()});
            return null;
        }
    }

    protected Stack<Throwable> unfoldExceptions(Throwable exception) {
        Stack<Throwable> throwables = new Stack<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.push(current);
        }
        return throwables;
    }

    private boolean asBooleanFromGlobalProp(String prop) {
        String value = this.getProject().getProperties().getProperty(prop);
        if (value == null) {
            value = System.getProperty(prop);
        }
        return value != null ? Boolean.valueOf(value) : false;
    }

    private KubernetesClient getKubernetes() {
        if (this.kubernetesClient == null) {
            String namespace = this.getNamespace();
            this.kubernetesClient = new DefaultKubernetesClient(((ConfigBuilder)new ConfigBuilder().withNamespace(namespace)).build());
        }
        return this.kubernetesClient;
    }

    private String getNamespace() {
        String namespace = this.getNamespaceConfig();
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = KubernetesHelper.defaultNamespace();
        }
        if (Strings.isNullOrBlank((String)namespace)) {
            namespace = "default";
        }
        return namespace;
    }

    private String getNamespaceConfig() {
        ResourceConfiguration config = this.getContext().getResourceConfiguration();
        return config != null ? config.getNamespace() : null;
    }

    private static enum Config implements Configs.Key
    {
        online{
            {
                this.d = "true";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

