/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherConfiguration;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Strings;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public abstract class BaseEnricher
implements Enricher {
    private final EnricherConfiguration config;
    private final String name;
    private EnricherContext buildContext;
    private KubernetesClient kubernetesClient;
    protected Logger log;

    public BaseEnricher(EnricherContext buildContext, String name) {
        this.buildContext = buildContext;
        this.config = new EnricherConfiguration(name, buildContext.getConfig());
        this.log = buildContext.getLog();
        this.name = name;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Map<String, String> getLabels(Kind kind) {
        return null;
    }

    @Override
    public Map<String, String> getAnnotations(Kind kind) {
        return null;
    }

    @Override
    public void adapt(KubernetesListBuilder builder) {
    }

    @Override
    public void addDefaultResources(KubernetesListBuilder builder) {
    }

    @Override
    public Map<String, String> getSelector(Kind kind) {
        return null;
    }

    protected MavenProject getProject() {
        return this.buildContext.getProject();
    }

    protected Logger getLog() {
        return this.log;
    }

    protected boolean isOffline() {
        return Configs.asBoolean((String)this.getConfig(Config.offline));
    }

    protected KubernetesClient getKubernetes() {
        if (this.kubernetesClient == null) {
            String ns = this.getNamespaceConfig();
            this.kubernetesClient = Strings.isNotBlank((String)ns) ? new DefaultKubernetesClient(((ConfigBuilder)new ConfigBuilder().withNamespace(ns)).build()) : new DefaultKubernetesClient();
        }
        return this.kubernetesClient;
    }

    private String getNamespaceConfig() {
        ResourceConfiguration resourceConfiguration = this.getContext().getResourceConfiguration();
        if (resourceConfiguration != null) {
            return resourceConfiguration.getNamespace();
        }
        return null;
    }

    protected List<ImageConfiguration> getImages() {
        return this.buildContext.getImages();
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected EnricherContext getContext() {
        return this.buildContext;
    }

    protected String getExternalServiceURL(String serviceName, String protocol) {
        String publicUrl = null;
        if (this.isOffline()) {
            this.getLog().info("Not looking for service " + serviceName + " as in offline mode");
        } else {
            try {
                KubernetesClient kubernetes = this.getKubernetes();
                String ns = kubernetes.getNamespace();
                Service service = (Service)((ClientResource)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(ns)).withName(serviceName)).get();
                if (service != null) {
                    publicUrl = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)serviceName, (String)ns, (String)protocol, (boolean)true);
                }
            }
            catch (Exception e) {
                this.getLog().warn("Failed to find service " + serviceName + ". May be in offline mode. Exception: " + e);
            }
        }
        return publicUrl;
    }

    private static enum Config implements Configs.Key
    {
        offline{
            {
                this.d = "false";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

