/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherConfiguration;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public abstract class BaseEnricher
implements Enricher {
    private final EnricherConfiguration config;
    private final String name;
    private EnricherContext buildContext;
    protected Logger log;

    public BaseEnricher(EnricherContext buildContext, String name) {
        this.buildContext = buildContext;
        this.config = new EnricherConfiguration(name, buildContext.getConfig());
        this.log = buildContext.getLog();
        this.name = name;
    }

    @Override
    public String getName() {
        return null;
    }

    protected MavenProject getProject() {
        return this.buildContext.getProject();
    }

    protected List<ImageConfiguration> getImages() {
        return this.buildContext.getImages();
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected EnricherContext getContext() {
        return this.buildContext;
    }

    @Override
    public Map<String, String> getLabels(Kind kind) {
        return null;
    }

    @Override
    public Map<String, String> getAnnotations(Kind kind) {
        return null;
    }

    @Override
    public void adapt(KubernetesListBuilder builder) {
    }

    @Override
    public void addDefaultResources(KubernetesListBuilder builder) {
    }

    @Override
    public Map<String, String> getSelector(Kind kind) {
        return null;
    }
}

