/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.customizer.spring.boot;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.DockerUtil;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.customizer.api.BaseCustomizer;
import io.fabric8.maven.customizer.api.MavenCustomizerContext;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public class SpringBootCustomizer
extends BaseCustomizer {
    public SpringBootCustomizer(MavenCustomizerContext context) {
        super(context, "spring.boot");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        MavenProject project = this.getProject();
        Properties properties = project.getProperties();
        if (!properties.containsKey("fabric8.docker.user")) {
            properties.put("fabric8.docker.user", this.prepareUserName());
        }
        if (!properties.containsKey("fabric8.docker.name")) {
            properties.put("fabric8.docker.name", this.prepareName());
        }
        boolean includeDefaultImage = false;
        if (this.isApplicable()) {
            boolean combineEnabled = Configs.asBoolean((String)this.getConfig(Config.combine));
            boolean bl = includeDefaultImage = !this.containsBuildConfiguration(configs) || combineEnabled;
        }
        if (includeDefaultImage && this.isApplicable()) {
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getBaseImage()).ports(this.extractPorts());
            this.addLatestIfSnapshot(buildBuilder);
            imageBuilder.name(this.extractImageName()).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    private void addLatestIfSnapshot(BuildImageConfiguration.Builder buildBuilder) {
        MavenProject project = this.getProject();
        if (project.getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    private String extractImageName() {
        return this.prepareUserName() + "/" + this.prepareName() + ":" + this.prepareVersion();
    }

    private String prepareName() {
        MavenProject project = this.getProject();
        return project.getProperties().getProperty("fabric8.docker.name", DockerUtil.prepareImageNamePart((MavenProject)project));
    }

    private String prepareUserName() {
        MavenProject project = this.getProject();
        return project.getProperties().getProperty("fabric8.docker.user", DockerUtil.prepareUserName((MavenProject)project));
    }

    private String prepareVersion() {
        MavenProject project = this.getProject();
        return project.getProperties().getProperty("fabric8.docker.label", project.getVersion());
    }

    private List<String> extractPorts() {
        return Arrays.asList("8080");
    }

    private String getBaseImage() {
        return "fabric8/java-alpine-openjdk8-jdk";
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir("/app").descriptorRef("spring-boot").build();
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration config : configs) {
            if (config.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicable() {
        MavenProject project = this.getProject();
        return MavenUtil.hasPlugin((MavenProject)project, (String)"org.springframework.boot:spring-boot-maven-plugin");
    }

    private static enum Config implements Configs.Key
    {
        combine{
            {
                ((Config)this).d = "false";
            }
        };

        private String d;

        public String def() {
            return this.d;
        }
    }
}

