/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.customizer.spring.boot;

import io.fabric8.maven.customizer.api.BaseCustomizer;
import io.fabric8.maven.customizer.api.MavenCustomizerContext;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class SpringBootCustomizer
extends BaseCustomizer {
    public SpringBootCustomizer(MavenCustomizerContext context) {
        super(context);
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        if (!this.containsBuildConfiguration(configs) && this.isApplicable()) {
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getBaseImage()).ports(this.extractPorts());
            this.addLatestIfSnapshot(buildBuilder);
            imageBuilder.name(this.extractImageName()).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    private void addLatestIfSnapshot(BuildImageConfiguration.Builder buildBuilder) {
        MavenProject project = this.getProject();
        if (project.getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    private String extractImageName() {
        MavenProject project = this.getProject();
        return this.prepareUserName(project.getGroupId()) + "/" + project.getArtifactId().toLowerCase() + ":" + project.getVersion();
    }

    private String prepareUserName(String groupId) {
        int idx = groupId.lastIndexOf(".");
        String last = groupId.substring(idx != -1 ? idx : 0);
        StringBuilder ret = new StringBuilder();
        for (char c : last.toCharArray()) {
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    private List<String> extractPorts() {
        return Arrays.asList("8080");
    }

    private String getBaseImage() {
        return "fabric8/java-alpine-openjdk8-jdk";
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir("/app").descriptorRef("spring-boot").build();
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration config : configs) {
            if (config.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicable() {
        MavenProject project = this.getProject();
        return project.getPlugin("org.springframework.boot:spring-boot-maven-plugin") != null;
    }
}

