/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.customizer.spring.boot;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.customizer.api.BaseCustomizer;
import io.fabric8.maven.customizer.api.MavenCustomizerContext;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class SpringBootCustomizer
extends BaseCustomizer {
    public SpringBootCustomizer(MavenCustomizerContext context) {
        super(context, "spring.boot");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        if (this.isApplicable() && this.shouldIncludeDefaultImage(configs)) {
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getConfig(Config.from)).ports(this.extractPorts());
            this.addLatestTagIfSnapshot(buildBuilder);
            imageBuilder.name(this.getConfig(Config.name)).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    private boolean shouldIncludeDefaultImage(List<ImageConfiguration> configs) {
        boolean combineEnabled = Configs.asBoolean((String)this.getConfig(Config.combine));
        return !this.containsBuildConfiguration(configs) || combineEnabled;
    }

    private void addLatestTagIfSnapshot(BuildImageConfiguration.Builder buildBuilder) {
        MavenProject project = this.getProject();
        if (project.getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    private List<String> extractPorts() {
        return Arrays.asList("8080");
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir("/app").descriptorRef("spring-boot").build();
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration config : configs) {
            if (config.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isApplicable() {
        MavenProject project = this.getProject();
        return MavenUtil.hasPlugin((MavenProject)project, (String)"org.springframework.boot:spring-boot-maven-plugin");
    }

    private static enum Config implements Configs.Key
    {
        combine{
            {
                this.d = "false";
            }
        }
        ,
        name{
            {
                this.d = "%g/%a:%l";
            }
        }
        ,
        from{
            {
                this.d = "fabric8/java-alpine-openjdk8-jdk";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

