/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.customizer.api;

import io.fabric8.maven.core.util.MavenProperties;
import io.fabric8.maven.customizer.api.BaseCustomizer;
import io.fabric8.maven.customizer.api.MavenCustomizerContext;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class DockerMavenPropertyCustomizer
extends BaseCustomizer {
    public DockerMavenPropertyCustomizer(MavenCustomizerContext context) {
        super(context, "docker.maven.properties");
    }

    @Override
    public List<ImageConfiguration> customize(List<ImageConfiguration> existingConfigs) {
        ArrayList<ImageConfiguration> answer = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration config : existingConfigs) {
            String newName;
            String name = config.getName();
            if (Objects.equals(name, newName = this.convertName(name))) {
                answer.add(config);
                continue;
            }
            ImageConfiguration.Builder builder = new ImageConfiguration.Builder();
            builder.alias(config.getAlias());
            builder.buildConfig(config.getBuildConfiguration());
            builder.externalConfig(config.getExternalConfig());
            builder.name(newName);
            builder.runConfig(config.getRunConfiguration());
            builder.watchConfig(config.getWatchConfiguration());
            answer.add(builder.build());
        }
        return answer;
    }

    protected String convertName(String name) {
        String answer = name;
        Properties properties = this.getProject().getProperties();
        for (String propertyName : MavenProperties.MAVEN_PROPERTIES) {
            String value = properties.getProperty(propertyName);
            if (!Strings.isNotBlank((String)value)) continue;
            answer = Strings.replaceAllWithoutRegex((String)answer, (String)("${" + propertyName + "}"), (String)value);
        }
        return answer;
    }
}

