/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.cm;

import io.fabric8.karaf.cm.KubernetesConstants;
import io.fabric8.karaf.core.properties.PlaceholderResolver;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE, createPid=false)
@Reference(name="resolver", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, referenceInterface=PlaceholderResolver.class)
@Properties(value={@Property(name="service.cmRanking", value={"10"}, classValue={Integer.class})})
@Service(value={ConfigurationPlugin.class})
public class PlaceholderResolverConfigurationPlugin
implements ConfigurationPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaceholderResolverConfigurationPlugin.class);
    private final AtomicReference<PlaceholderResolver> resolver = new AtomicReference();
    private boolean enabled = KubernetesConstants.FABRIC8_CONFIG_PLUGIN_ENABLED_DEFAULT;

    @Activate
    void activate() {
        this.enabled = Utils.getSystemPropertyOrEnvVar((String)"fabric8.config.plugin.enabled", (Boolean)this.enabled);
        LOGGER.debug("Configuration update is {}", (Object)(this.enabled ? "ENABLED" : "DISABLED"));
    }

    protected void bindResolver(PlaceholderResolver resolver) {
        this.resolver.set(resolver);
    }

    protected void unbindResolver(PlaceholderResolver resolver) {
        this.resolver.compareAndSet(resolver, null);
    }

    public void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> dictionary) {
        PlaceholderResolver res = this.resolver.get();
        if (this.enabled && res != null) {
            res.replaceAll(dictionary);
        }
    }
}

