/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.cm;

import io.fabric8.karaf.cm.KubernetesConstants;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.StringReader;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.IGNORE, createPid=false)
@References(value={@Reference(name="configAdmin", referenceInterface=ConfigurationAdmin.class, policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY_UNARY), @Reference(name="kubernetesClient", referenceInterface=KubernetesClient.class, policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY_UNARY)})
public class KubernetesConfigAdminBridge
implements Watcher<ConfigMap> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesConfigAdminBridge.class);
    private final Object lock;
    private final AtomicReference<ConfigurationAdmin> configAdmin;
    private final AtomicReference<KubernetesClient> kubernetesClient;
    private boolean enabled = KubernetesConstants.FABRIC8_CM_BRIDGE_ENABLED_DEFAULT;
    private String pidLabel = "karaf.pid";
    private Map<String, String> filters = null;
    private Watch watch = null;
    private boolean configMerge;
    private boolean configMeta;
    private boolean configWatch;

    public KubernetesConfigAdminBridge() {
        this.lock = new Object();
        this.configAdmin = new AtomicReference();
        this.kubernetesClient = new AtomicReference();
        this.configMerge = KubernetesConstants.FABRIC8_CONFIG_MERGE_DEFAULT;
        this.configMeta = KubernetesConstants.FABRIC8_CONFIG_META_DEFAULT;
        this.configWatch = KubernetesConstants.FABRIC8_CONFIG_WATCH_DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate() {
        this.enabled = Utils.getSystemPropertyOrEnvVar((String)"fabric8.cm.bridge.enabled", (Boolean)this.enabled);
        this.pidLabel = Utils.getSystemPropertyOrEnvVar((String)"fabric8.pid.label", (String)this.pidLabel);
        this.configMerge = Utils.getSystemPropertyOrEnvVar((String)"fabric8.config.merge", (Boolean)this.configMerge);
        this.configMeta = Utils.getSystemPropertyOrEnvVar((String)"fabric8.config.meta", (Boolean)this.configMeta);
        this.configWatch = Utils.getSystemPropertyOrEnvVar((String)"fabric8.config.watch", (Boolean)this.configWatch);
        this.filters = new HashMap<String, String>();
        String filterList = Utils.getSystemPropertyOrEnvVar((String)"fabric8.pid.filters");
        if (!Utils.isNullOrEmpty((String)filterList)) {
            for (String filter : filterList.split(",")) {
                String[] kv = filter.split("=");
                if (kv.length != 2) continue;
                this.filters.put(kv[0].trim(), kv[1].trim());
            }
        }
        if (this.enabled) {
            Object object = this.lock;
            synchronized (object) {
                this.watchConfigMapList();
                ConfigMapList list = this.getConfigMapList();
                if (list != null) {
                    for (ConfigMap map : list.getItems()) {
                        this.updateConfig(map);
                    }
                }
            }
        }
    }

    @Deactivate
    void deactivate() {
        if (this.watch != null) {
            this.watch.close();
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.set(service);
    }

    protected void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.compareAndSet(service, null);
    }

    protected void bindKubernetesClient(KubernetesClient service) {
        this.kubernetesClient.set(service);
    }

    protected void unbindKubernetesClient(KubernetesClient service) {
        this.kubernetesClient.compareAndSet(service, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReceived(Watcher.Action action, ConfigMap map) {
        Object object = this.lock;
        synchronized (object) {
            switch (action) {
                case ADDED: 
                case MODIFIED: {
                    this.updateConfig(map);
                    break;
                }
                case DELETED: 
                case ERROR: {
                    this.deleteConfig(map);
                }
            }
        }
    }

    public void onClose(KubernetesClientException e) {
    }

    private void updateConfig(ConfigMap map) {
        Long ver = Long.parseLong(map.getMetadata().getResourceVersion());
        String pid = (String)map.getMetadata().getLabels().get(this.pidLabel);
        String[] p = this.parsePid(pid);
        try {
            boolean bl;
            String cfgString;
            Configuration config = this.getConfiguration(this.configAdmin.get(), pid, p[0], p[1]);
            Map configMapData = map.getData();
            if (configMapData == null) {
                LOGGER.debug("Ignoring configuration pid={}, (empty)", (Object)config.getPid());
                return;
            }
            Dictionary props = config.getProperties();
            Hashtable<String, Object> configAdmCfg = props != null ? new Hashtable<String, Object>() : null;
            Hashtable<String, Object> configMapCfg = new Hashtable<String, Object>();
            String pidCfg = (String)configMapData.get("fabric8.config.pid.cfg");
            if (pidCfg == null) {
                pidCfg = pid + ".cfg";
            }
            if (Utils.isNotNullOrEmpty((String)(cfgString = (String)configMapData.get(pidCfg)))) {
                Properties cfg = new Properties();
                cfg.load(new StringReader(cfgString));
                for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
                    configMapCfg.put((String)entry.getKey(), entry.getValue());
                }
            } else {
                for (Map.Entry entry : map.getData().entrySet()) {
                    configMapCfg.put((String)entry.getKey(), entry.getValue());
                }
            }
            boolean meta = configMapData.containsKey("fabric8.config.meta") ? Boolean.valueOf((String)configMapData.get("fabric8.config.meta")) : this.configMeta;
            boolean bl2 = bl = configMapData.containsKey("fabric8.config.merge") ? Boolean.valueOf((String)configMapData.get("fabric8.config.merge")) : this.configMerge;
            if (configAdmCfg != null) {
                Long oldVer = (Long)props.get("fabric8.k8s.meta.resourceVersion");
                if (oldVer != null && oldVer >= ver) {
                    LOGGER.debug("Ignoring configuration pid={}, oldVersion={} newVersion={} (no changes)", new Object[]{config.getPid(), oldVer, ver});
                    return;
                }
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object val = props.get(key);
                    configAdmCfg.put(key, val);
                }
            }
            if (this.shouldUpdate(configAdmCfg, configMapCfg)) {
                LOGGER.debug("Updating configuration pid={}", (Object)config.getPid());
                if (meta) {
                    configMapCfg.put("fabric8.pid", pid);
                    configMapCfg.put("fabric8.k8s.meta.resourceVersion", ver);
                    configMapCfg.put("fabric8.k8s.meta.name", map.getMetadata().getName());
                    configMapCfg.put("fabric8.k8s.meta.namespace", map.getMetadata().getNamespace());
                }
                if (bl && configAdmCfg != null) {
                    for (Map.Entry<String, Object> entry : configMapCfg.entrySet()) {
                        if (KubernetesConstants.CM_META_KEYS.contains(entry.getKey())) continue;
                        configAdmCfg.put(entry.getKey(), entry.getValue());
                    }
                    configMapCfg = configAdmCfg;
                }
                config.update(configMapCfg);
            } else {
                LOGGER.debug("Ignoring configuration pid={} (no changes)", (Object)config.getPid());
            }
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    private void deleteConfig(ConfigMap map) {
        String pid = (String)map.getMetadata().getLabels().get(this.pidLabel);
        String[] p = this.parsePid(pid);
        try {
            Map configMapData = map.getData();
            Configuration config = this.getConfiguration(this.configAdmin.get(), pid, p[0], p[1]);
            if (configMapData != null) {
                boolean merge;
                boolean bl = merge = configMapData.containsKey("fabric8.config.merge") ? Boolean.valueOf((String)configMapData.get("fabric8.config.merge")) : this.configMerge;
                if (!merge) {
                    LOGGER.debug("Delete configuration {}", (Object)config.getPid());
                    config.delete();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    private String[] parsePid(String pid) {
        String factoryPid = null;
        int n = pid.indexOf(45);
        if (n > 0) {
            factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
        }
        return new String[]{pid, factoryPid};
    }

    private ConfigMapList getConfigMapList() {
        KubernetesClient client = this.kubernetesClient.get();
        return client != null ? (ConfigMapList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.configMaps().withLabel(this.pidLabel)).withLabels(this.filters)).list() : null;
    }

    private void watchConfigMapList() {
        if (this.configWatch) {
            KubernetesClient client = this.kubernetesClient.get();
            if (client != null) {
                this.watch = (Watch)((FilterWatchListDeletable)((FilterWatchListDeletable)client.configMaps().withLabel(this.pidLabel)).withLabels(this.filters)).watch((Object)this);
            } else {
                throw new RuntimeException("KubernetesClient not set");
            }
        }
    }

    private Configuration getConfiguration(ConfigurationAdmin configAdmin, String fabric8pid, String pid, String factoryPid) throws Exception {
        String filter = "(fabric8.pid=" + fabric8pid + ")";
        Configuration[] oldConfiguration = configAdmin.listConfigurations(filter);
        if (oldConfiguration != null && oldConfiguration.length > 0) {
            return oldConfiguration[0];
        }
        return factoryPid != null ? configAdmin.createFactoryConfiguration(pid, null) : configAdmin.getConfiguration(pid, null);
    }

    private boolean shouldUpdate(Hashtable<String, Object> configAdmCfg, Hashtable<String, Object> configMapCfg) {
        if (configAdmCfg == null) {
            return true;
        }
        for (Map.Entry<String, Object> entry : configMapCfg.entrySet()) {
            if (KubernetesConstants.FABRIC8_META_KEYS.contains(entry.getKey())) continue;
            Object value = configAdmCfg.get(entry.getKey());
            if (value == null) {
                return true;
            }
            if (value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

