/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.HealthChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthCheckServlet
extends HttpServlet {
    private final CopyOnWriteArrayList<HealthChecker> checkers;

    public HealthCheckServlet(CopyOnWriteArrayList<HealthChecker> checkers) {
        this.checkers = checkers;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<Check> checks = new ArrayList<Check>();
        for (HealthChecker checker : this.checkers) {
            checks.addAll(checker.getFailingHealthChecks());
        }
        if (checks.isEmpty()) {
            resp.getWriter().println("HEALTHY");
        } else {
            resp.setStatus(503);
            resp.getWriter().println("NOT HEALTHY");
            for (Check check : checks) {
                resp.getWriter().println(check.getName() + ": " + check.getLongDescription());
            }
        }
    }
}

