/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class BootFeaturesState
extends AbstractChecker {
    @Override
    protected List<Check> doCheck() {
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            if (!"org.apache.karaf.features.core".equals(bundle.getSymbolicName()) || this.bootFeaturesInstalled(bundle)) continue;
            return Collections.singletonList(new Check("boot-features-state", "Boot Features are not yet installed"));
        }
        return Collections.emptyList();
    }

    private boolean bootFeaturesInstalled(Bundle bundle) {
        if (bundle.getVersion().getMajor() < 4) {
            File file = bundle.getBundleContext().getDataFile("FeaturesServiceState.properties");
            if (!file.exists()) {
                return false;
            }
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(file);){
                props.load(is);
            }
            catch (IOException e) {
                return false;
            }
            return Boolean.parseBoolean((String)props.get("bootFeaturesInstalled"));
        }
        ServiceReference ref = this.bundleContext.getServiceReference("org.apache.karaf.features.BootFinished");
        return ref != null;
    }
}

