/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.ReadinessChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReadinessCheckServlet
extends HttpServlet {
    private final CopyOnWriteArrayList<ReadinessChecker> checkers;

    public ReadinessCheckServlet(CopyOnWriteArrayList<ReadinessChecker> readinessCheckers) {
        this.checkers = readinessCheckers;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<Check> checks = new ArrayList<Check>();
        for (ReadinessChecker checker : this.checkers) {
            checks.addAll(checker.getFailingReadinessChecks());
        }
        if (checks.isEmpty()) {
            resp.getWriter().println("READY");
        } else {
            resp.setStatus(503);
            resp.getWriter().println("NOT READY");
            for (Check check : checks) {
                resp.getWriter().println(check.getName() + ": " + check.getLongDescription());
            }
        }
    }
}

