/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractBundleChecker;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;

public class ScrState
extends AbstractBundleChecker {
    private final ServiceTracker<ScrService, ScrService> tracker;

    public ScrState() {
        this.tracker = new ServiceTracker(this.bundleContext, ScrService.class, null);
        this.tracker.open();
    }

    @Override
    protected Check checkBundle(Bundle bundle) {
        if (bundle.getHeaders().get("Service-Component") == null) {
            return null;
        }
        ScrService svc = (ScrService)this.tracker.getService();
        if (svc == null) {
            return new Check("scr-state", "No ScrService found");
        }
        Component[] components = svc.getComponents(bundle);
        if (components != null) {
            for (Component component : components) {
                int state = component.getState();
                if (state == 16 || state == 32 || state == 64) continue;
                return new Check("scr-state", "SCR bundle " + bundle.getBundleId() + " is in state " + this.getState(state));
            }
        }
        return null;
    }

    private String getState(int state) {
        switch (state) {
            case 1: {
                return "disabled";
            }
            case 512: {
                return "enabling";
            }
            case 2: {
                return "enabled";
            }
            case 4: {
                return "unsatisfied";
            }
            case 8: {
                return "activating";
            }
            case 16: {
                return "active";
            }
            case 32: {
                return "registered";
            }
            case 64: {
                return "factory";
            }
            case 128: {
                return "deactivating";
            }
            case 1024: {
                return "disabling";
            }
            case 2048: {
                return "disposing";
            }
            case 256: {
                return "disposed";
            }
        }
        return "unknown: " + state;
    }
}

