/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.util.tracker.ServiceTracker;

public class CamelState
extends AbstractChecker {
    private ServiceTracker<MBeanServer, MBeanServer> mbeanServer;

    public CamelState() {
        this.mbeanServer = new ServiceTracker(this.bundleContext, MBeanServer.class, null);
        this.mbeanServer.open();
    }

    @Override
    protected List<Check> doCheck() {
        MBeanServer server = (MBeanServer)this.mbeanServer.getService();
        if (server != null) {
            try {
                ArrayList<Check> checks = new ArrayList<Check>();
                Set<ObjectName> contexts = server.queryNames(new ObjectName("org.apache.camel:type=context,*"), null);
                for (ObjectName ctxName : contexts) {
                    String state = server.getAttribute(ctxName, "State").toString();
                    if ("Started".equals(state)) continue;
                    String name = ctxName.getKeyProperty("name");
                    checks.add(new Check("camel-state", "Camel context " + name + " is in state " + state));
                }
                return checks;
            }
            catch (Exception e) {
                return Collections.singletonList(new Check("camel-state", "Unable to check camel contexts: " + e.toString()));
            }
        }
        return Collections.emptyList();
    }
}

