/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractBundleChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

public class BlueprintState
extends AbstractBundleChecker
implements BlueprintListener {
    private final Map<Long, BlueprintEvent> states = new ConcurrentHashMap<Long, BlueprintEvent>();

    public BlueprintState() {
        this.bundleContext.registerService(BlueprintListener.class, (Object)this, null);
    }

    public void blueprintEvent(BlueprintEvent event) {
        this.states.put(event.getBundle().getBundleId(), event);
    }

    @Override
    public Check checkBundle(Bundle bundle) {
        BlueprintEvent event = this.states.get(bundle.getBundleId());
        if (event != null && event.getType() != 2 && this.isActive(bundle)) {
            return new Check("blueprint-state", "Blueprint bundle " + bundle.getBundleId() + " is in state " + this.getState(event));
        }
        return null;
    }

    private String getState(BlueprintEvent blueprintEvent) {
        switch (blueprintEvent.getType()) {
            case 1: {
                return "CREATING";
            }
            case 2: {
                return "CREATED";
            }
            case 3: {
                return "DESTROYING";
            }
            case 4: {
                return "DESTROYED";
            }
            case 5: {
                return "FAILURE";
            }
            case 6: {
                return "GRACE_PERIOD";
            }
            case 7: {
                return "WAITING";
            }
        }
        return "UNKNOWN";
    }
}

