/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractBundleChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.ops4j.pax.web.service.spi.WebListener;
import org.osgi.framework.Bundle;

public class WarState
extends AbstractBundleChecker
implements WebListener {
    private final Map<Long, WebEvent> states = new ConcurrentHashMap<Long, WebEvent>();

    public WarState() {
        this.bundleContext.registerService(WebListener.class, (Object)this, null);
    }

    public void webEvent(WebEvent event) {
        this.states.put(event.getBundle().getBundleId(), event);
    }

    @Override
    public Check checkBundle(Bundle bundle) {
        WebEvent event = this.states.get(bundle.getBundleId());
        if (event != null && event.getType() != 2 && this.isActive(bundle)) {
            return new Check("war-state", "War bundle " + bundle.getBundleId() + " is in state " + this.getState(event));
        }
        return null;
    }

    private String getState(WebEvent webEvent) {
        switch (webEvent.getType()) {
            case 2: {
                return "DEPLOYED";
            }
            case 1: {
                return "DEPLOYING";
            }
            case 5: {
                return "FAILED";
            }
            case 4: {
                return "UNDEPLOYED";
            }
            case 3: {
                return "UNDEPLOYING";
            }
            case 6: {
                return "WAITING";
            }
        }
        return "UNKNOWN";
    }
}

