/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.Check;
import io.fabric8.karaf.checks.internal.AbstractChecker;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public abstract class AbstractBundleChecker
extends AbstractChecker {
    @Override
    protected List<Check> doCheck() {
        ArrayList<Check> checks = new ArrayList<Check>();
        for (Bundle b : this.systemBundleContext.getBundles()) {
            Check check = this.checkBundle(b);
            if (check == null) continue;
            checks.add(check);
        }
        return checks;
    }

    protected abstract Check checkBundle(Bundle var1);

    protected boolean isActive(Bundle bundle) {
        String activationPolicyHeader;
        if (bundle.getState() == 32) {
            return true;
        }
        return bundle.getState() == 8 && (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy");
    }

    protected boolean isFragment(Bundle bundle) {
        return (((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0;
    }
}

