/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.karaf.checks.internal;

import io.fabric8.karaf.checks.HealthChecker;
import io.fabric8.karaf.checks.ReadinessChecker;
import io.fabric8.karaf.checks.internal.BlueprintState;
import io.fabric8.karaf.checks.internal.BootFeaturesState;
import io.fabric8.karaf.checks.internal.BundleState;
import io.fabric8.karaf.checks.internal.FrameworkState;
import io.fabric8.karaf.checks.internal.HealthCheckServlet;
import io.fabric8.karaf.checks.internal.ReadinessCheckServlet;
import io.fabric8.karaf.checks.internal.ScrState;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

@Component(name="io.fabric8.karaf.k8s.check", immediate=true, enabled=true, policy=ConfigurationPolicy.IGNORE, createPid=false)
public class ChecksService {
    @Reference(referenceInterface=HttpService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private HttpService httpService;
    @Reference(referenceInterface=ReadinessChecker.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    final CopyOnWriteArrayList<ReadinessChecker> readinessCheckers = new CopyOnWriteArrayList();
    @Reference(referenceInterface=HealthChecker.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    final CopyOnWriteArrayList<HealthChecker> healthCheckers = new CopyOnWriteArrayList();
    String readinessCheckPath = "/readiness-check";
    String healthCheckPath = "/health-check";

    public ChecksService() {
        this.bind(new FrameworkState());
        this.bind(new BundleState());
        this.bind(new BootFeaturesState());
        try {
            this.bind(new BlueprintState());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bind(new ScrState());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void bind(Object checker) {
        if (checker instanceof ReadinessChecker) {
            this.bindReadinessCheckers((ReadinessChecker)checker);
        }
        if (checker instanceof HealthChecker) {
            this.bindHealthCheckers((HealthChecker)checker);
        }
    }

    @Activate
    void activate(Map<String, ?> configuration) throws ServletException, NamespaceException {
        this.httpService.registerServlet(this.readinessCheckPath, (Servlet)new ReadinessCheckServlet(this.readinessCheckers), null, null);
        this.httpService.registerServlet(this.healthCheckPath, (Servlet)new HealthCheckServlet(this.healthCheckers), null, null);
    }

    @Deactivate
    void deactivate() {
        this.httpService.unregister(this.readinessCheckPath);
        this.httpService.unregister(this.healthCheckPath);
    }

    void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    void unbindHttpService(HttpService service) {
        this.httpService = null;
    }

    void bindReadinessCheckers(ReadinessChecker value) {
        this.readinessCheckers.add(value);
    }

    void unbindReadinessCheckers(ReadinessChecker value) {
        this.readinessCheckers.remove(value);
    }

    void bindHealthCheckers(HealthChecker value) {
        this.healthCheckers.add(value);
    }

    void unbindHealthCheckers(HealthChecker value) {
        this.healthCheckers.remove(value);
    }
}

