/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops.connector;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.utils.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environments {
    private static final transient Logger LOG = LoggerFactory.getLogger(Environments.class);
    public static final String ENVIRONMENTS_CONFIG_MAP_NAME = "fabric8-environments";

    public static ConfigMap getOrCreateEnvironments(KubernetesClient client, String namespace) {
        ConfigMap answer = null;
        try {
            answer = (ConfigMap)((ClientResource)((KubernetesClient)client.inNamespace(namespace)).configMaps().withName(ENVIRONMENTS_CONFIG_MAP_NAME)).get();
        }
        catch (Exception e) {
            LOG.info("Failed to find ConfigMap " + namespace + "." + ENVIRONMENTS_CONFIG_MAP_NAME + ". " + e, (Throwable)e);
        }
        if (answer == null || KubernetesHelper.getName((HasMetadata)answer) == null) {
            answer = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(ENVIRONMENTS_CONFIG_MAP_NAME)).addToLabels("kind", "environments")).addToLabels("provider", "fabric8.io")).endMetadata()).build();
        }
        return answer;
    }

    public static boolean ensureEnvironmentAdded(ConfigMap environmentsConfigMap, String key, String label, String namespace) {
        String yaml;
        boolean answer = false;
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        Map oldData = environmentsConfigMap.getData();
        if (oldData != null) {
            data.putAll(oldData);
            environmentsConfigMap.setData(data);
        }
        if (Strings.isNullOrBlank((String)(yaml = (String)data.get(key)))) {
            yaml = "name: " + label + "\nnamespace: " + namespace + "\norder: " + data.size();
            data.put(key, yaml);
            answer = true;
        }
        if (answer) {
            environmentsConfigMap.setData(data);
        }
        return answer;
    }
}

