/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cdi.weld.internal.endpoints;

import io.fabric8.cdi.Fabric8Extension;
import io.fabric8.cdi.MockConfigurer;
import io.fabric8.cdi.weld.internal.endpoints.RandomEndpointToUrl;
import io.fabric8.cdi.weld.internal.endpoints.ServiceInstanceUsingFactoryAndEndpoints;
import io.fabric8.cdi.weld.internal.endpoints.ServiceInstanceWithEndpoint;
import io.fabric8.cdi.weld.internal.endpoints.ServiceInstanceWithMultiPortEndpoint;
import io.fabric8.cdi.weld.internal.endpoints.ServiceListInstanceWithEndpoint;
import io.fabric8.cdi.weld.internal.endpoints.ServiceListInstanceWithEndpoint2;
import io.fabric8.cdi.weld.internal.endpoints.ServiceListWithoutEndpoint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class EndpointsInternalTest {
    private static WeldContainer weld;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setUpClass() {
        MockConfigurer.configure();
        weld = new Weld().disableDiscovery().extensions(new Extension[]{new Fabric8Extension()}).beanClasses(new Class[]{RandomEndpointToUrl.class, ServiceListInstanceWithEndpoint.class, ServiceInstanceWithEndpoint.class, ServiceListWithoutEndpoint.class, ServiceListInstanceWithEndpoint2.class, ServiceListInstanceWithEndpoint.class, ServiceListInstanceWithEndpoint2.class, ServiceInstanceWithMultiPortEndpoint.class, ServiceInstanceUsingFactoryAndEndpoints.class}).initialize();
    }

    @AfterClass
    public static void cleanUp() {
        if (weld != null) {
            weld.shutdown();
        }
    }

    @Test
    public void testServiceListWithoutEndpoint() {
        ServiceListWithoutEndpoint obj = EndpointsInternalTest.createInstance(ServiceListWithoutEndpoint.class);
        Assert.assertEquals((long)2L, (long)obj.getService().size());
        Assert.assertTrue((boolean)obj.getService().contains("tcp://10.0.0.1:8080"));
        Assert.assertTrue((boolean)obj.getService().contains("tcp://10.0.0.2:8080"));
    }

    @Test
    public void testServiceListInstanceWithEndpoint() {
        ServiceListInstanceWithEndpoint obj = EndpointsInternalTest.createInstance(ServiceListInstanceWithEndpoint.class);
        Assert.assertEquals((long)2L, (long)((List)obj.getService().get()).size());
        Assert.assertTrue((boolean)((List)obj.getService().get()).contains("tcp://10.0.0.1:8080"));
        Assert.assertTrue((boolean)((List)obj.getService().get()).contains("tcp://10.0.0.2:8080"));
    }

    @Test
    public void testServiceInstanceWithEndpoint() {
        ServiceInstanceWithEndpoint obj = EndpointsInternalTest.createInstance(ServiceInstanceWithEndpoint.class);
        Assert.assertTrue((obj.getService().equals("tcp://10.0.0.1:8080") || obj.getService().contains("tcp://10.0.0.2:8080") ? 1 : 0) != 0);
    }

    @Test
    public void testServiceInstanceWithMultiPortEndpoint() {
        ServiceInstanceWithMultiPortEndpoint obj = EndpointsInternalTest.createInstance(ServiceInstanceWithMultiPortEndpoint.class);
        Assert.assertEquals((Object)"http://172.30.17.2:8082", (Object)obj.getService());
    }

    @Test
    public void testServiceInstanceWithFactoryAndMultipleEndpoints() {
        ServiceInstanceUsingFactoryAndEndpoints obj = EndpointsInternalTest.createInstance(ServiceInstanceUsingFactoryAndEndpoints.class);
        Assert.assertNotNull((Object)obj.getService());
    }

    @Test
    public void testChangingEndpoints() {
        ServiceListInstanceWithEndpoint2 obj = EndpointsInternalTest.createInstance(ServiceListInstanceWithEndpoint2.class);
        ArrayList endpoints = new ArrayList((Collection)obj.getService().get());
        Assert.assertTrue((boolean)endpoints.contains("tcp://10.0.0.1:8080"));
        Assert.assertTrue((boolean)endpoints.contains("tcp://10.0.0.2:8080"));
        endpoints = new ArrayList((Collection)obj.getService().get());
        Assert.assertTrue((boolean)endpoints.contains("tcp://10.0.0.1:8080"));
        Assert.assertFalse((boolean)endpoints.contains("tcp://10.0.0.2:8080"));
    }

    static <T> T createInstance(Class<T> type) {
        CreationalContext ctx = weld.getBeanManager().createCreationalContext(null);
        Iterator iterator = weld.getBeanManager().getBeans(type, new Annotation[0]).iterator();
        if (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            return (T)weld.getBeanManager().getReference(bean, type, ctx);
        }
        return null;
    }
}

