/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cdi.weld.internal;

import io.fabric8.cdi.deltaspike.DeltaspikeTestBase;
import io.fabric8.cdi.weld.ClientProducer;
import io.fabric8.cdi.weld.NestingFactoryBean;
import io.fabric8.cdi.weld.SimpleBean;
import io.fabric8.cdi.weld.StringToURL;
import io.fabric8.cdi.weld.URLToConnection;
import io.fabric8.cdi.weld.UrlBean;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.net.URL;
import java.util.Set;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ExtensionInternalTest {
    @Inject
    private KubernetesClient client;
    @Inject
    @New
    private SimpleBean simpleBean;
    @Inject
    @New
    private UrlBean urlBean;
    @Inject
    @New
    private StringToURL stringToURL;
    @Inject
    @New
    private NestingFactoryBean nestingFactoryBean;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{StringToURL.class, URLToConnection.class, NestingFactoryBean.class, SimpleBean.class, UrlBean.class, ClientProducer.class})).addClasses(DeltaspikeTestBase.getDeltaSpikeHolders())).addAsWebInfResource("META-INF/beans.xml")).addAsLibraries((File[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.deltaspike.core:deltaspike-core-impl")).withTransitivity()).as(File.class));
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("CONFIG1_TEST", "value1");
        System.setProperty("CONFIG2_TEST", "value2");
        System.setProperty("SERVICE1_PROTOCOL", "https");
        System.setProperty("SERVICE3_PROTOCOL", "https");
        System.setProperty("kubernetes.namespace", "default");
    }

    @Test
    public void testClientInjection() {
        Assert.assertNotNull((Object)this.client);
    }

    @Test
    public void testServiceInjection() {
        Assert.assertNotNull((Object)this.simpleBean);
        Assert.assertNotNull((Object)this.simpleBean.getOptionalUrl());
        Assert.assertNotNull((Object)this.simpleBean.getUrl());
    }

    @Test
    public void testProtocolOveride() {
        Assert.assertTrue((boolean)this.simpleBean.getTestUrl().startsWith("tst"));
    }

    @Test
    public void testConfigInjection() {
        Assert.assertNotNull((Object)this.simpleBean);
        Assert.assertEquals((Object)"value1", (Object)this.simpleBean.getConfig1().getProperty());
        Assert.assertEquals((Object)"value2", (Object)this.simpleBean.getConfig2().getProperty());
    }

    @Test
    public void testFactory() {
        Assert.assertNotNull((Object)this.urlBean);
        Assert.assertNotNull((Object)this.urlBean.getService3());
        Assert.assertNotNull((Object)this.urlBean.getService1());
        Assert.assertTrue((boolean)this.urlBean.getService1().toString().startsWith("https"));
        Assert.assertTrue((boolean)this.urlBean.getService3().toString().startsWith("https"));
    }

    @Test
    public void testAlias() {
        Set beans = CDI.current().getBeanManager().getBeans("cool-id");
        Assert.assertNotNull((Object)beans);
        Assert.assertEquals((long)1L, (long)beans.size());
        Assert.assertEquals(URL.class, (Object)((Bean)beans.iterator().next()).getBeanClass());
    }

    @Test
    public void testMultiport() {
        Assert.assertNotNull((Object)this.simpleBean);
        Assert.assertTrue((boolean)this.simpleBean.getMultiportDefault().endsWith("8081"));
        Assert.assertTrue((boolean)this.simpleBean.getMultiport2().endsWith("8082"));
    }

    @Test
    public void testNestingFactories() {
        Assert.assertNotNull((Object)this.nestingFactoryBean);
        Assert.assertNotNull((Object)this.nestingFactoryBean.getService1());
        Assert.assertNotNull((Object)this.nestingFactoryBean.getService2());
    }
}

