/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cdi.weld;

import io.fabric8.kubernetes.api.model.EditableEndpoints;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.RootPathsBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.mock.KubernetesMockClient;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.RouteListBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.mock.OpenShiftMockClient;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;

@Singleton
public class ClientProducer {
    @Produces
    @Alternative
    public KubernetesClient getKubernetesClient() throws MalformedURLException {
        KubernetesMockClient mock = new KubernetesMockClient();
        mock.getMasterUrl().andReturn((Object)new URL("https://kubernetes.default.svc")).anyTimes();
        mock.rootPaths().andReturn((Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(new String[]{"/api", "/api/v1beta3", "/api/v1", "/controllers", "/healthz", "/healthz/ping", "/logs/", "/metrics", "/ready", "/osapi", "/osapi/v1beta3", "/oapi", "/oapi/v1", "/swaggerapi/"})).build()).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.services().inNamespace("default")).withName("service1")).get()).andReturn((Object)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(80))).withNewTargetPort(Integer.valueOf(9090))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build()).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.services().inNamespace("default")).withName("service2")).get()).andReturn((Object)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service2")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(80))).withNewTargetPort(Integer.valueOf(8080))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build()).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.services().inNamespace("default")).withName("service3")).get()).andReturn((Object)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service3")).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withPort(Integer.valueOf(443))).withNewTargetPort(Integer.valueOf(443))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build()).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.services().inNamespace("default")).withName("multiport")).get()).andReturn((Object)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("multiport")).endMetadata()).withNewSpec().addNewPort().withName("port1")).withProtocol("TCP")).withPort(Integer.valueOf(8081))).withNewTargetPort(Integer.valueOf(8081))).endPort()).addNewPort().withName("port2")).withProtocol("TCP")).withPort(Integer.valueOf(8082))).withNewTargetPort(Integer.valueOf(8082))).endPort()).addNewPort().withName("port3")).withProtocol("TCP")).withPort(Integer.valueOf(8083))).withNewTargetPort(Integer.valueOf(8083))).endPort()).withPortalIP("172.30.17.2")).endSpec()).build()).anyTimes();
        EditableEndpoints service1Endpoints = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("service1")).withNamespace("default")).endMetadata()).addNewSubset().addNewPort().withName("port")).withPort(Integer.valueOf(8080))).endPort()).addNewAddresse().withIp("10.0.0.1")).endAddresse()).endSubset()).addNewSubset().addNewPort().withName("port")).withPort(Integer.valueOf(8080))).endPort()).addNewAddresse().withIp("10.0.0.2")).endAddresse()).endSubset()).build();
        EditableEndpoints service2EndpointsA = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("service2")).withNamespace("default")).endMetadata()).addNewSubset().addNewPort().withName("port")).withPort(Integer.valueOf(8080))).endPort()).addNewAddresse().withIp("10.0.0.1")).endAddresse()).endSubset()).addNewSubset().addNewPort().withName("port")).withPort(Integer.valueOf(8080))).endPort()).addNewAddresse().withIp("10.0.0.2")).endAddresse()).endSubset()).build();
        EditableEndpoints service2EndpointsB = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.PortsNested)((EndpointSubsetFluent.PortsNested)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("service2")).withNamespace("default")).endMetadata()).addNewSubset().addNewPort().withName("port")).withPort(Integer.valueOf(8080))).endPort()).addNewAddresse().withIp("10.0.0.1")).endAddresse()).endSubset()).build();
        EditableEndpoints multiPortEndpoint = ((EndpointsBuilder)((EndpointsFluent.SubsetsNested)((EndpointsFluent.SubsetsNested)((EndpointsFluent.SubsetsNested)((EndpointsFluent.SubsetsNested)((EndpointSubsetFluent.AddressesNested)((EndpointsBuilder)((EndpointsFluent.MetadataNested)((EndpointsFluent.MetadataNested)new EndpointsBuilder().withNewMetadata().withName("multiport")).withNamespace("default")).endMetadata()).addNewSubset().addNewAddresse().withIp("172.30.17.2")).endAddresse()).addNewPort("port1", Integer.valueOf(8081), "TCP")).addNewPort("port2", Integer.valueOf(8082), "TCP")).addNewPort("port3", Integer.valueOf(8083), "TCP")).endSubset()).build();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.endpoints().inNamespace("default")).withName("service1")).get()).andReturn((Object)service1Endpoints).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.endpoints().inNamespace("default")).withName("service2")).get()).andReturn((Object)service2EndpointsA).once();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.endpoints().inNamespace("default")).withName("service2")).get()).andReturn((Object)service2EndpointsB).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.endpoints().inNamespace("default")).withName("multiport")).get()).andReturn((Object)multiPortEndpoint).anyTimes();
        mock.adapt(OpenShiftClient.class).andReturn((Object)this.getOpenShiftClient()).anyTimes();
        mock.getNamespace().andAnswer((IAnswer)new IAnswer<String>(){

            public String answer() throws Throwable {
                return Utils.getEnvVar((String)"KUBERNETES_NAMESPACE", null);
            }
        }).anyTimes();
        return mock.replay();
    }

    @Produces
    @Alternative
    public OpenShiftClient getOpenShiftClient() throws MalformedURLException {
        OpenShiftMockClient mock = new OpenShiftMockClient();
        ((IExpectationSetters)((MockNonNamespaceOperation)mock.routes().inNamespace("default")).list()).andReturn((Object)new RouteListBuilder().build()).anyTimes();
        ((IExpectationSetters)((MockResource)((MockNonNamespaceOperation)mock.routes().inNamespace("default")).withName((String)EasyMock.anyObject())).get()).andReturn(null).anyTimes();
        return mock.replay();
    }
}

