/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cdi.weld;

import io.fabric8.cdi.deltaspike.DeltaspikeTestBase;
import io.fabric8.cdi.weld.NestingFactoryBean;
import io.fabric8.cdi.weld.ServiceStringBean;
import io.fabric8.cdi.weld.ServiceUrlBean;
import io.fabric8.cdi.weld.StringToURL;
import io.fabric8.cdi.weld.URLToConnection;
import io.fabric8.kubernetes.api.KubernetesClient;
import java.io.File;
import java.net.URL;
import java.util.Set;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ExtensionTest {
    @Inject
    private KubernetesClient kubernetesClient;
    @Inject
    @New
    private ServiceStringBean serviceLocationBean;
    @Inject
    @New
    private ServiceUrlBean serviceUrlBean;
    @Inject
    @New
    private StringToURL stringToURL;
    @Inject
    @New
    private NestingFactoryBean nestingFactoryBean;

    @BeforeClass
    public static void setUp() {
        System.setProperty("MY_CONFIG_TEST", "value1");
        System.setProperty("MY_OTHER_CONFIG_TEST", "value2");
        System.setProperty("FABRIC8_CONSOLE_SERVICE_PROTOCOL", "https");
        System.setProperty("KUBERNETES_PROTOCOL", "https");
    }

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{StringToURL.class, URLToConnection.class, NestingFactoryBean.class, ServiceStringBean.class, ServiceUrlBean.class})).addClasses(DeltaspikeTestBase.getDeltaSpikeHolders())).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"))).addAsLibraries((File[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.deltaspike.core:deltaspike-core-impl")).withTransitivity()).as(File.class));
    }

    @Test
    public void testClientInjection() {
        Assert.assertNotNull((Object)this.kubernetesClient);
    }

    @Test
    public void testServiceInjection() {
        Assert.assertNotNull((Object)this.serviceLocationBean);
        Assert.assertNotNull((Object)this.serviceLocationBean.getKubernetesUrl());
        Assert.assertNotNull((Object)this.serviceLocationBean.getConsoleUrl());
    }

    @Test
    public void testProtocolOveride() {
        Assert.assertTrue((boolean)this.serviceLocationBean.getTestUrl().startsWith("tst"));
    }

    @Test
    public void testConfigInjection() {
        Assert.assertNotNull((Object)this.serviceLocationBean);
        Assert.assertEquals((Object)"value1", (Object)this.serviceLocationBean.getConfigBean().getProperty());
        Assert.assertEquals((Object)"value2", (Object)this.serviceLocationBean.getOtherConfigBean().getProperty());
    }

    @Test
    public void testFactory() {
        Assert.assertNotNull((Object)this.serviceUrlBean);
        Assert.assertNotNull((Object)this.serviceUrlBean.getKubernetesUrl());
        Assert.assertNotNull((Object)this.serviceUrlBean.getConsoleUrl());
        Assert.assertTrue((boolean)this.serviceUrlBean.getConsoleUrl().toString().startsWith("https"));
        Assert.assertTrue((boolean)this.serviceUrlBean.getKubernetesUrl().toString().startsWith("https"));
    }

    @Test
    public void testAlias() {
        Set beans = CDI.current().getBeanManager().getBeans("cool-id");
        Assert.assertNotNull((Object)beans);
        Assert.assertEquals((long)1L, (long)beans.size());
        Assert.assertEquals(URL.class, (Object)((Bean)beans.iterator().next()).getBeanClass());
    }

    @Test
    public void testNestingFacvtories() {
        Assert.assertNotNull((Object)this.nestingFactoryBean);
        Assert.assertNotNull((Object)this.nestingFactoryBean.getConsoleConnection());
        Assert.assertNotNull((Object)this.nestingFactoryBean.getAppLibraryConnection());
    }
}

