/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build.trigger;

import io.fabric8.utils.Strings;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemHandlers {
    private static final transient Logger LOG = LoggerFactory.getLogger(WorkItemHandlers.class);

    public static String getMandatoryParameter(WorkItem workItem, WorkItemManager manager, String parameterName) {
        String answer = (String)workItem.getParameter(parameterName);
        if (Strings.isNullOrBlank((String)answer)) {
            WorkItemHandlers.fail(workItem, manager, "Missing workflow parameter value '" + parameterName + "' but has parameters: " + workItem.getParameters());
        }
        return answer;
    }

    public static void fail(WorkItem workItem, WorkItemManager manager, String message, Throwable exception) {
        UndeclaredThrowableException undeclaredThrowableException;
        Throwable undeclaredThrowable;
        if (exception instanceof UndeclaredThrowableException && (undeclaredThrowable = (undeclaredThrowableException = (UndeclaredThrowableException)exception).getUndeclaredThrowable()) != null && !undeclaredThrowable.equals(exception)) {
            exception = undeclaredThrowable;
        }
        String reason = message + ". Exception: " + exception;
        LOG.error("Failed work item " + workItem.getId() + ":" + workItem.getName() + ":  " + reason, exception);
        WorkItemHandlers.completeWithFailureReason(workItem, manager, reason);
    }

    public static void fail(WorkItem workItem, WorkItemManager manager, String reason) {
        LOG.error("Failed work item " + workItem.getId() + ":" + workItem.getName() + ":  " + reason);
        WorkItemHandlers.completeWithFailureReason(workItem, manager, reason);
    }

    protected static void completeWithFailureReason(WorkItem workItem, WorkItemManager manager, String reason) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Failed", reason);
        manager.completeWorkItem(workItem.getId(), result);
    }
}

