/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build.correlate;

import io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBuildProcessCorrelator
implements BuildProcessCorrelator {
    private static final transient Logger LOG = LoggerFactory.getLogger(MemoryBuildProcessCorrelator.class);
    private Map<BuildCorrelationKey, Long> map = new ConcurrentHashMap<BuildCorrelationKey, Long>();

    @Override
    public void putBuildWorkItemId(BuildCorrelationKey buildKey, long processInstanceId) {
        Long oldPid = this.map.get(buildKey);
        if (oldPid != null) {
            LOG.warn("Already associated build key " + buildKey + " with processID: " + oldPid + " so ignoring newer process: " + processInstanceId);
            return;
        }
        this.map.put(buildKey, processInstanceId);
    }

    @Override
    public Long findWorkItemIdForBuild(BuildCorrelationKey buildKey) {
        return this.map.get(buildKey);
    }
}

