/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build;

import io.fabric8.kubernetes.api.builds.BuildFinishedEvent;

public class BuildCorrelationKey {
    private final String namespace;
    private final String buildName;
    private final String buildUuid;

    public static BuildCorrelationKey create(BuildFinishedEvent event) {
        return new BuildCorrelationKey(event.getNamespace(), event.getConfigName(), event.getUid());
    }

    public BuildCorrelationKey(String namespace, String buildName, String buildUuid) {
        this.namespace = namespace;
        this.buildName = buildName;
        this.buildUuid = buildUuid;
    }

    public String toString() {
        return "BuildCorrelationKey{namespace='" + this.namespace + '\'' + ", buildName='" + this.buildName + '\'' + ", buildUuid='" + this.buildUuid + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildCorrelationKey that = (BuildCorrelationKey)o;
        if (!this.buildName.equals(that.buildName)) {
            return false;
        }
        if (!this.buildUuid.equals(that.buildUuid)) {
            return false;
        }
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.buildName.hashCode();
        result = 31 * result + this.buildUuid.hashCode();
        return result;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getBuildUuid() {
        return this.buildUuid;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

