/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build.simulator;

import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.workflow.build.signal.BuildSignaller;
import io.fabric8.workflow.build.simulator.SimulatorBuildFinishedEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

public class BuildSimulator {
    public static final String FABRIC8_SIMULATOR_ENABLED = "FABRIC8_SIMULATOR_ENABLED";
    public static final String FABRIC8_SIMULATOR_START_BUILD_NAME = "FABRIC8_SIMULATOR_START_BUILD_NAME";
    private static BuildSimulator singleton;
    private AtomicLong buildCounter = new AtomicLong(0L);
    private Timer timer;
    private long pollTime;
    private BuildSignaller buildListener;
    private String consoleLink;
    private String startBuildName = "A";
    private String startBuildNamespace = "default";
    private long initialBuildDelay = 1000L;
    private long startBuildPeriod = 30000L;

    public static boolean isEnabled() {
        String value = Systems.getEnvVarOrSystemProperty((String)FABRIC8_SIMULATOR_ENABLED, (String)FABRIC8_SIMULATOR_ENABLED, (String)"false");
        if (Strings.isNotBlank((String)value)) {
            return value.toLowerCase().equals("true");
        }
        return false;
    }

    public static BuildSimulator getSingleton() {
        if (singleton == null) {
            singleton = new BuildSimulator();
        }
        return singleton;
    }

    public String triggerBuild(String namespace, String buildName) {
        String uuid = "" + this.buildCounter.incrementAndGet();
        final BuildCorrelationKey key = new BuildCorrelationKey(namespace, buildName, uuid);
        TimerTask notifyBuildTask = new TimerTask(){

            @Override
            public void run() {
                System.out.println("Triggering build for: " + key);
                BuildSimulator.this.notifyBuild(key);
            }
        };
        this.timer.schedule(notifyBuildTask, 2L * this.pollTime);
        return uuid;
    }

    public void schedule(Timer timer, long pollTime, BuildSignaller buildListener, String consoleLink) {
        this.timer = timer;
        this.pollTime = pollTime;
        this.buildListener = buildListener;
        this.consoleLink = consoleLink;
        this.startBuildName = Systems.getEnvVarOrSystemProperty((String)FABRIC8_SIMULATOR_START_BUILD_NAME, (String)this.startBuildName);
        TimerTask startBuildTask = new TimerTask(){

            @Override
            public void run() {
                BuildSimulator.this.triggerBuild(BuildSimulator.this.startBuildNamespace, BuildSimulator.this.startBuildName);
            }
        };
        timer.schedule(startBuildTask, this.initialBuildDelay, this.startBuildPeriod);
    }

    protected void notifyBuild(BuildCorrelationKey key) {
        SimulatorBuildFinishedEvent event = new SimulatorBuildFinishedEvent(key, this.consoleLink);
        this.buildListener.onBuildFinished(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        Object lock = new Object();
        while (true) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public String getStartBuildName() {
        return this.startBuildName;
    }

    public void setStartBuildName(String startBuildName) {
        this.startBuildName = startBuildName;
    }

    public String getStartBuildNamespace() {
        return this.startBuildNamespace;
    }

    public void setStartBuildNamespace(String startBuildNamespace) {
        this.startBuildNamespace = startBuildNamespace;
    }

    public long getStartBuildPeriod() {
        return this.startBuildPeriod;
    }

    public void setStartBuildPeriod(long startBuildPeriod) {
        this.startBuildPeriod = startBuildPeriod;
    }

    public long getInitialBuildDelay() {
        return this.initialBuildDelay;
    }

    public void setInitialBuildDelay(long initialBuildDelay) {
        this.initialBuildDelay = initialBuildDelay;
    }
}

