/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build.signal;

import io.fabric8.kubernetes.api.builds.BuildFinishedEvent;
import io.fabric8.kubernetes.api.builds.BuildListener;
import io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import io.fabric8.workflow.build.dto.BuildFinishedDTO;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSignaller
implements BuildListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildSignaller.class);
    private final KieSession ksession;
    private final BuildProcessCorrelator buildProcessCorrelator;
    private String startBuildProcessId = "io.fabric8.cdelivery.StartBuildProcess";

    public BuildSignaller(KieSession ksession, BuildProcessCorrelator buildProcessCorrelator) {
        this.ksession = ksession;
        this.buildProcessCorrelator = buildProcessCorrelator;
    }

    public void onBuildFinished(BuildFinishedEvent event) {
        String namespace = event.getNamespace();
        String buildName = event.getConfigName();
        String buildUuid = event.getUid();
        String buildLink = event.getBuildLink();
        System.out.println("Build: " + buildUuid + " for config: " + buildName + " finished. Status: " + event.getStatus() + " link: " + buildLink);
        BuildCorrelationKey key = BuildCorrelationKey.create(event);
        HashMap<String, String> signalObject = new HashMap<String, String>();
        signalObject.put("buildUuid", buildUuid);
        signalObject.put("buildLink", buildLink);
        BuildFinishedDTO buildFinishedDTO = new BuildFinishedDTO(event);
        Long workItemId = this.buildProcessCorrelator.findWorkItemIdForBuild(key);
        if (workItemId == null) {
            String startNodeName = BuildSignaller.getStartSignalName(namespace, buildName);
            LOG.info("No existing processes associated with build " + key + " so lets signal a new process to start");
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            inputParameters.put("startSignalName", startNodeName);
            LOG.info("Starting process: " + this.startBuildProcessId + " with inputParameters: " + inputParameters);
            ProcessInstance processInstance = this.ksession.startProcess(this.startBuildProcessId, inputParameters);
        } else {
            HashMap<String, Object> results = new HashMap<String, Object>();
            BuildSignaller.populateParameters(results, buildFinishedDTO);
            LOG.info("Completing work item id: " + workItemId + " for " + key + " with data: " + results);
            try {
                this.ksession.getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
            }
            catch (Exception e) {
                LOG.error("Could not complete work item " + workItemId + " for " + key + " with data: " + results + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    protected static void populateParameters(Map<String, Object> parameters, BuildFinishedDTO buildFinishedDTO) {
        parameters.put("namespace", buildFinishedDTO.getNamespace());
        parameters.put("buildName", buildFinishedDTO.getBuildName());
        parameters.put("buildUuid", buildFinishedDTO.getBuildUuid());
        parameters.put("buildLink", buildFinishedDTO.getBuildLink());
        parameters.put("status", buildFinishedDTO.getStatus());
    }

    public static String getStartSignalName(String namespace, String buildName) {
        return namespace + "/" + buildName;
    }
}

