/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.workflow.build.simulator;

import io.fabric8.kubernetes.api.builds.BuildFinishedEvent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.workflow.build.BuildCorrelationKey;
import java.util.Date;

public class SimulatorBuildFinishedEvent
extends BuildFinishedEvent {
    private final BuildCorrelationKey key;

    public SimulatorBuildFinishedEvent(BuildCorrelationKey key, String buildLink) {
        super(key.getBuildUuid(), SimulatorBuildFinishedEvent.createBuild(key), false, buildLink);
        this.key = key;
    }

    public String getConfigName() {
        return this.key.getBuildName();
    }

    protected static Build createBuild(BuildCorrelationKey key) {
        Build build = new Build();
        build.setMetadata(new ObjectMeta());
        build.getMetadata().setName(key.getBuildName());
        build.getMetadata().setNamespace(key.getNamespace());
        build.getMetadata().setUid(key.getBuildUuid());
        BuildStatus status = new BuildStatus();
        status.setCompletionTimestamp(new Date().toString());
        build.setStatus(status);
        return build;
    }
}

