/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.io.fabric8.workflow.build.trigger;

import com.ning.http.client.ws.WebSocket;
import io.fabric8.io.fabric8.workflow.build.trigger.BuildTrigger;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DefaultBuildTrigger
implements BuildTrigger {
    private final KubernetesClient kubernetes;

    public DefaultBuildTrigger() {
        this((KubernetesClient)new DefaultKubernetesClient());
    }

    public DefaultBuildTrigger(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String trigger(String namespace, final String buildName) {
        final ArrayBlockingQueue uuid = new ArrayBlockingQueue(1);
        try (WebSocket webSocket = ((ClientNonNamespaceOperation)((OpenShiftClient)this.kubernetes.adapt(OpenShiftClient.class)).builds().inNamespace(namespace)).watch((Watcher)new Watcher<Build>(){

            public void eventReceived(Watcher.Action action, Build build) {
                if (action == Watcher.Action.ADDED && KubernetesHelper.getName((HasMetadata)build).equals(buildName)) {
                    uuid.add(Builds.getUid((Build)build));
                }
            }
        });){
            String string = (String)uuid.poll(60L, TimeUnit.SECONDS);
            return string;
        }
        catch (InterruptedException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

