/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.io.fabric8.workflow.build.signal;

import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelators;
import io.fabric8.io.fabric8.workflow.build.signal.BuildSignaller;
import io.fabric8.io.fabric8.workflow.build.simulator.BuildSimulator;
import io.fabric8.kubernetes.api.builds.BuildListener;
import io.fabric8.kubernetes.api.builds.BuildWatcher;
import io.fabric8.kubernetes.api.builds.Links;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.OpenShiftClient;
import java.util.Timer;
import org.kie.api.runtime.KieSession;

public class BuildSignallerService {
    private final KieSession ksession;
    private final String namespace;
    private OpenShiftClient client = new DefaultKubernetesClient();
    private Timer timer = new Timer();
    private BuildProcessCorrelator buildProcessCorrelator = BuildProcessCorrelators.getSingleton();
    private BuildWatcher watcher;
    private BuildSimulator simulator;
    private String consoleLink;

    public BuildSignallerService(KieSession ksession) {
        this(ksession, null);
    }

    public BuildSignallerService(KieSession ksession, String namespace) {
        this.ksession = ksession;
        this.namespace = namespace;
    }

    public void start() {
        String consoleLink = this.getConsoleLink();
        BuildSignaller buildListener = new BuildSignaller(this.ksession, this.buildProcessCorrelator);
        long pollTime = 3000L;
        if (BuildSimulator.isEnabled()) {
            this.simulator = BuildSimulator.getSingleton();
            this.simulator.schedule(this.timer, pollTime, buildListener, consoleLink);
        } else {
            this.watcher = new BuildWatcher(this.client, (BuildListener)buildListener, this.namespace, consoleLink);
            this.watcher.schedule(this.timer, pollTime);
        }
    }

    public void stop() {
        this.timer.cancel();
    }

    public void join() {
        if (this.watcher != null) {
            this.watcher.join();
        } else if (this.simulator != null) {
            this.simulator.join();
        }
    }

    public BuildProcessCorrelator getBuildProcessCorrelator() {
        return this.buildProcessCorrelator;
    }

    public void setBuildProcessCorrelator(BuildProcessCorrelator buildProcessCorrelator) {
        this.buildProcessCorrelator = buildProcessCorrelator;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(OpenShiftClient client) {
        this.client = client;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public String getConsoleLink() {
        if (this.consoleLink == null) {
            this.consoleLink = Links.getFabric8ConsoleLink();
        }
        return this.consoleLink;
    }

    public void setConsoleLink(String consoleLink) {
        this.consoleLink = consoleLink;
    }
}

