/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.io.fabric8.workflow.build.trigger;

import io.fabric8.io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelators;
import io.fabric8.io.fabric8.workflow.build.trigger.BuildTrigger;
import io.fabric8.io.fabric8.workflow.build.trigger.BuildTriggers;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWorkItemHandler
implements WorkItemHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildWorkItemHandler.class);
    private BuildProcessCorrelator buildProcessCorrelator = BuildProcessCorrelators.getSingleton();
    private BuildTrigger buildTrigger = BuildTriggers.getSingleton();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        long processInstanceId = workItem.getProcessInstanceId();
        String buildName = (String)workItem.getParameter("BuildName");
        String namespace = (String)workItem.getParameter("Namespace");
        LOG.info("Executing namespace: " + namespace + " build: " + buildName + " processInstanceId: " + processInstanceId + " workItemId: " + workItem.getId());
        if (Strings.isNullOrBlank((String)namespace)) {
            this.fail(workItem, manager, "Missing workflow configuration for Namespace");
        } else if (Strings.isNullOrBlank((String)buildName)) {
            this.fail(workItem, manager, "Missing workflow configuration for BuildName");
        } else {
            String buildUuid = this.buildTrigger.trigger(namespace, buildName);
            if (Strings.isNullOrBlank((String)buildUuid)) {
                this.fail(workItem, manager, "Could not trigger build for namespace: " + namespace + " build: " + buildName);
            } else {
                BuildCorrelationKey key = new BuildCorrelationKey(namespace, buildName, buildUuid);
                this.buildProcessCorrelator.putBuildProcessInstanceId(key, processInstanceId);
            }
        }
    }

    protected void fail(WorkItem workItem, WorkItemManager manager, String reason) {
        LOG.error("Failed to complete work item " + workItem.getId() + " due to: " + reason);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Failed", reason);
        manager.completeWorkItem(workItem.getId(), result);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        System.out.println("Aborting " + workItem.getParameter("BuildId"));
    }

    public BuildTrigger getBuildTrigger() {
        return this.buildTrigger;
    }

    public void setBuildTrigger(BuildTrigger buildTrigger) {
        this.buildTrigger = buildTrigger;
    }

    public BuildProcessCorrelator getBuildProcessCorrelator() {
        return this.buildProcessCorrelator;
    }

    public void setBuildProcessCorrelator(BuildProcessCorrelator buildProcessCorrelator) {
        this.buildProcessCorrelator = buildProcessCorrelator;
    }
}

