/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.io.fabric8.workflow.build.signal;

import io.fabric8.io.fabric8.workflow.build.BuildCorrelationKey;
import io.fabric8.io.fabric8.workflow.build.correlate.BuildProcessCorrelator;
import io.fabric8.kubernetes.api.builds.BuildFinishedEvent;
import io.fabric8.kubernetes.api.builds.BuildListener;
import java.util.HashMap;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSignaller
implements BuildListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildSignaller.class);
    private final KieBase kbase;
    private final RuntimeEngine engine;
    private final BuildProcessCorrelator buildProcessCorrelator;
    private final KieSession ksession;

    public BuildSignaller(KieBase kbase, RuntimeEngine engine, BuildProcessCorrelator buildProcessCorrelator) {
        this.kbase = kbase;
        this.engine = engine;
        this.buildProcessCorrelator = buildProcessCorrelator;
        this.ksession = engine.getKieSession();
    }

    public void onBuildFinished(BuildFinishedEvent event) {
        String buildName = event.getConfigName();
        String buildUuid = event.getUid();
        String buildLink = event.getBuildLink();
        System.out.println("Build: " + buildUuid + " for config: " + buildName + " finished. Status: " + event.getStatus() + " link: " + buildLink);
        BuildCorrelationKey key = BuildCorrelationKey.create(event);
        HashMap<String, String> signalObject = new HashMap<String, String>();
        signalObject.put("buildUuid", buildUuid);
        signalObject.put("buildLink", buildLink);
        Long processId = this.buildProcessCorrelator.findProcessInstanceIdForBuild(key);
        if (processId == null) {
            LOG.info("No existing processes associated with build " + key + " so lets signal a new process to start");
            this.ksession.signalEvent(buildName, signalObject);
        } else {
            LOG.info("Signalling event on process id: " + processId + " for " + key + " with data: " + signalObject);
            this.ksession.signalEvent(buildName, signalObject, processId.longValue());
        }
    }
}

