/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tools.apt;

import io.fabric8.tools.apt.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;

public class JavaDocs {
    public static String findParameterJavaDoc(String javadoc, String parameterName) {
        String prefix;
        Pattern regex = Pattern.compile(".*\\s+@param\\s+" + parameterName + "\\s+(.*)");
        Matcher matcher = regex.matcher(javadoc);
        if (matcher.find() && !Strings.isNullOrEmpty(prefix = matcher.group(1))) {
            Pattern nextTag = Pattern.compile("\\s+(@param|@return|@exception|@throws|@serialData|@see|@since|@deprecated)");
            Matcher endMatcher = nextTag.matcher(prefix);
            if (endMatcher.find()) {
                int start = endMatcher.start();
                return prefix.substring(0, start).trim();
            }
            return prefix;
        }
        return null;
    }

    public static String getJavaDoc(Elements elementUtils, Element element) {
        if (elementUtils != null) {
            String parentDoc;
            String description = elementUtils.getDocComment(element);
            if (Strings.isNullOrEmpty(description) && element.getKind() == ElementKind.PARAMETER && !Strings.isNullOrEmpty(parentDoc = JavaDocs.getJavaDoc(elementUtils, element.getEnclosingElement()))) {
                return JavaDocs.findParameterJavaDoc(parentDoc, element.getSimpleName().toString());
            }
            return description;
        }
        return null;
    }
}

