/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tools.apt;

import io.fabric8.tools.apt.AbstractAnnotationProcessor;
import io.fabric8.tools.apt.JavaDocs;
import io.fabric8.tools.apt.JsonSchemaTypes;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.apache.deltaspike.core.api.config.ConfigProperty;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ConfigPropertyAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ConfigProperty.class);
        if (!elements.isEmpty()) {
            StringBuilder buffer = new StringBuilder("{");
            buffer.append("\n  \"type\": \"object\",");
            this.log("options: " + this.processingEnv.getOptions());
            buffer.append("\n  \"properties\": {");
            boolean first = true;
            for (Element element : elements) {
                this.processEndpointClass(roundEnv, element, buffer, first);
                first = false;
            }
            buffer.append("\n  }");
            buffer.append("\n}");
            buffer.append("\n");
            String text = buffer.toString();
            this.writeFile("io.fabric8.environment", "schema.json", text);
        }
        return true;
    }

    protected void processEndpointClass(RoundEnvironment roundEnv, Element element, StringBuilder buffer, boolean first) {
        ConfigProperty property = element.getAnnotation(ConfigProperty.class);
        if (property != null) {
            String defaultValue = property.defaultValue();
            if ("org.apache.deltaspike.NullValueMarker".equals(defaultValue)) {
                defaultValue = null;
            }
            String name = property.name();
            String description = JavaDocs.getJavaDoc(this.getElements(), element);
            String javaTypeName = ConfigPropertyAnnotationProcessor.javaTypeName(element);
            String jsonType = JsonSchemaTypes.getJsonSchemaTypeName(javaTypeName);
            if (!first) {
                buffer.append(",");
            }
            buffer.append("\n    \"").append(name).append("\": {");
            buffer.append("\n      \"type\": \"").append(jsonType).append("\",");
            if (defaultValue != null) {
                buffer.append("\n      \"default\": \"").append(defaultValue).append("\",");
            }
            if (description != null && (description = description.trim()).length() > 0) {
                buffer.append("\n      \"description\": \"").append(description).append("\",");
            }
            buffer.append("\n      \"javaType\": \"").append(javaTypeName).append("\"");
            buffer.append("\n    }");
        }
    }
}

