/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tools.apt;

import io.fabric8.tools.apt.IOHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    protected static String javaTypeName(Element element) {
        TypeMirror typeMirror = element.asType();
        return typeMirror.toString();
    }

    protected void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    protected void warning(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
    }

    protected void error(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    protected void log(Throwable e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.close();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String packageName, String fileName, String text) {
        FileWriter writer;
        block10: {
            writer = null;
            try {
                FileObject resource;
                Filer filer = this.processingEnv.getFiler();
                try {
                    resource = filer.getResource(StandardLocation.CLASS_OUTPUT, packageName, fileName);
                }
                catch (Throwable e) {
                    resource = filer.createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]);
                }
                URI uri = resource.toUri();
                File file = null;
                if (uri != null) {
                    try {
                        file = new File(uri.getPath());
                    }
                    catch (Exception e) {
                        this.warning("Could not convert output directory resource URI to a file " + e);
                    }
                }
                if (file == null) {
                    this.warning("No class output directory could be found!");
                    break block10;
                }
                file.getParentFile().mkdirs();
                this.log("Generating file " + file);
                writer = new FileWriter(file);
                writer.write(text);
            }
            catch (IOException e) {
                try {
                    this.log(e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(writer);
                    throw throwable;
                }
                IOHelper.close(writer);
            }
        }
        IOHelper.close(writer);
    }

    public Elements getElements() {
        Elements elementUtils = null;
        if (this.processingEnv != null) {
            elementUtils = this.processingEnv.getElementUtils();
        }
        return elementUtils;
    }
}

