/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testApp;

import io.fabric8.testApp.TestLoad;
import io.fabric8.testApp.TestThreadFactory;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TestApp {
    public static ObjectName AGENT_MBEAN_NAME;
    protected static AtomicBoolean enabledAgent;
    private static ExecutorService pool;

    public static void main(String[] args) throws Exception {
        try {
            System.err.println("RUNNING ...");
            TestApp.checkEnabledMetrics();
            int COUNT = 20;
            for (int i = 0; i < 20; ++i) {
                TestLoad testLoad = new TestLoad();
                pool.submit(testLoad);
            }
            TestLoad testLoad = new TestLoad(1000);
            pool.submit(testLoad);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.err.println("WAITING FOR LOAD TO COMPLETE ...");
        pool.awaitTermination(5L, TimeUnit.MINUTES);
        System.err.println("STOPPED");
    }

    protected static void checkEnabledMetrics() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer != null && mBeanServer.isRegistered(AGENT_MBEAN_NAME) && enabledAgent.compareAndSet(false, true)) {
            try {
                mBeanServer.invoke(AGENT_MBEAN_NAME, "startMetrics", new Object[0], new String[0]);
                System.out.println("Enabled agent metrics " + AGENT_MBEAN_NAME);
            }
            catch (Exception e) {
                System.out.println("Failed to invoke the mbean: " + AGENT_MBEAN_NAME);
                e.printStackTrace();
            }
        }
    }

    static {
        enabledAgent = new AtomicBoolean(false);
        pool = Executors.newCachedThreadPool(new TestThreadFactory("TestLoad"));
        try {
            AGENT_MBEAN_NAME = new ObjectName("io.fabric8.apmagent", "type", "apmAgent");
        }
        catch (MalformedObjectNameException e) {
            System.out.println("Failed to create object name: " + e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

