/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import com.codahale.metrics.Timer;
import io.fabric8.apmagent.metrics.MethodMetrics;
import io.fabric8.apmagent.metrics.ThreadContextMethodMetricsStack;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadContextMethodMetrics
extends MethodMetrics {
    private final Thread thread;
    private final AtomicReference<ThreadContextMethodMetricsStack> stackRef;
    private Timer.Context timerContext;

    public ThreadContextMethodMetrics(Thread thread, AtomicReference<ThreadContextMethodMetricsStack> stackRef, String name) {
        super(name);
        this.thread = thread;
        this.stackRef = stackRef;
    }

    public String getThreadName() {
        return this.thread.getName();
    }

    public long getThreadId() {
        return this.thread.getId();
    }

    public void onEnter() {
        this.timerContext = this.timer.time();
        this.stackRef.get().push(this);
    }

    public long onExit() {
        long result = -1L;
        ThreadContextMethodMetrics last = this.stackRef.get().pop();
        if (last == this) {
            result = this.timerContext.stop();
        } else {
            while (last != null && last != this) {
                result = last.timerContext.stop();
                last = this.stackRef.get().pop();
            }
            if (last == this) {
                result = this.timerContext.stop();
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "ThreadContextMethodMetrics:" + this.getName();
    }
}

