/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.history;

import java.io.Serializable;
import java.util.LinkedList;
import org.jolokia.history.HistoryLimit;
import org.jolokia.history.ValueEntry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class HistoryEntry
implements Serializable {
    private static final long serialVersionUID = 42L;
    private LinkedList<ValueEntry> values;
    private HistoryLimit limit;

    HistoryEntry(HistoryLimit pLimit) {
        this.limit = pLimit;
        this.values = new LinkedList();
    }

    public JSONArray jsonifyValues() {
        JSONArray jValues = new JSONArray();
        for (ValueEntry vEntry : this.values) {
            JSONObject o = new JSONObject();
            o.put("value", vEntry.getValue());
            o.put("timestamp", vEntry.getTimestamp());
            jValues.add(o);
        }
        return jValues;
    }

    public void setLimit(HistoryLimit pLimit) {
        this.limit = pLimit;
        this.trim();
    }

    public void setMaxEntries(int pMaxEntries) {
        this.setLimit(new HistoryLimit(pMaxEntries, this.limit.getMaxDuration()));
    }

    public void add(Object pObject, long pTime) {
        this.values.addFirst(new ValueEntry(pObject, pTime));
        this.trim();
    }

    private void trim() {
        while (this.values.size() > this.limit.getMaxEntries()) {
            this.values.removeLast();
        }
        if (this.limit.getMaxDuration() > 0L && !this.values.isEmpty()) {
            long duration = this.limit.getMaxDuration();
            long start = this.values.getFirst().getTimestamp();
            while (start - this.values.getLast().getTimestamp() > duration) {
                this.values.removeLast();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryEntry");
        sb.append("{values=").append(this.values);
        sb.append(", limit=").append(this.limit);
        sb.append('}');
        return sb.toString();
    }
}

