/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.strategy.sampling;

import io.fabric8.apmagent.ApmConfiguration;
import io.fabric8.apmagent.Strategy;
import io.fabric8.apmagent.metrics.ApmAgentContext;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SamplingStrategy
implements Strategy,
Runnable {
    private static final long CLEANUP_INTERVAL = 1000L;
    private ApmAgentContext context;
    private ApmConfiguration configuration;
    private AtomicBoolean initialized = new AtomicBoolean();
    private AtomicBoolean started = new AtomicBoolean();
    private Thread samplingThread;
    private final Map<Long, String> currentMethods = new HashMap<Long, String>();

    public SamplingStrategy(ApmAgentContext context) {
        this.context = context;
        this.configuration = context.getConfiguration();
    }

    @Override
    public void initialize() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            this.samplingThread = new Thread((Runnable)this, "Fabric8-ApmAgent-SamplingStrategy");
            this.samplingThread.setDaemon(true);
            this.configuration.addChangeListener(this);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.initialize();
            this.samplingThread.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            // empty if block
        }
    }

    @Override
    public void shutDown() throws Exception {
        if (this.initialized.compareAndSet(true, false)) {
            this.configuration.removeChangeListener(this);
            this.samplingThread = null;
        }
    }

    @Override
    public void configurationChanged() {
    }

    @Override
    public void run() {
        long lastTime = 0L;
        while (this.started.get()) {
            try {
                for (Map.Entry<Thread, StackTraceElement[]> threadEntry : Thread.getAllStackTraces().entrySet()) {
                    if (threadEntry.getKey() == Thread.currentThread()) continue;
                    this.addMeasurement(threadEntry.getKey(), threadEntry.getValue());
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastTime > 1000L) {
                    this.cleanup();
                    lastTime = currentTime;
                }
                Thread.sleep(this.configuration.getSamplingInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void cleanup() {
        ArrayList<ThreadInfo> removeList = null;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (Long id : this.currentMethods.keySet()) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(id);
            if (threadInfo == null || threadInfo.getThreadState() != Thread.State.TERMINATED) continue;
            if (removeList == null) {
                removeList = new ArrayList<ThreadInfo>();
            }
            removeList.add(threadInfo);
        }
        if (removeList != null) {
            for (ThreadInfo threadInfo : removeList) {
                this.currentMethods.remove(threadInfo.getThreadId());
            }
        }
    }

    private void addMeasurement(Thread thread, StackTraceElement[] stackTraceElements) {
        if (thread != null && thread.isAlive() && stackTraceElements != null && stackTraceElements.length > 0) {
            StackTraceElement topOfStack = stackTraceElements[0];
            String currentMethod = this.getCurrentMethod(topOfStack);
            if (this.configuration.isAudit(topOfStack.getClassName(), topOfStack.getMethodName())) {
                String lastMethod = this.currentMethods.put(thread.getId(), currentMethod);
                if (lastMethod == null) {
                    this.context.enterMethod(thread, currentMethod, true);
                } else if (!lastMethod.equals(currentMethod)) {
                    this.context.exitMethod(thread, lastMethod, true);
                }
            }
        }
    }

    private String getCurrentMethod(StackTraceElement topOfStack) {
        StringBuilder stringBuilder = new StringBuilder(topOfStack.getClassName().length() + topOfStack.getMethodName().length() + 1);
        stringBuilder.append(topOfStack.getClassName()).append(".").append(topOfStack.getMethodName());
        return stringBuilder.toString();
    }
}

