/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent;

import io.fabric8.apmagent.MethodDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClassInfo {
    private ClassLoader classLoader;
    private Class originalClass;
    private String className;
    private byte[] original;
    private byte[] transformed;
    private boolean canTransform;
    private ConcurrentMap<String, MethodDescription> transformedMethods = new ConcurrentHashMap<String, MethodDescription>();
    private ConcurrentMap<String, MethodDescription> allMethods = new ConcurrentHashMap<String, MethodDescription>();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className != null ? className.replace("/", ".") : null;
    }

    public byte[] getOriginal() {
        return this.original;
    }

    public void setOriginal(byte[] original) {
        this.original = original;
    }

    public Class getOriginalClass() {
        return this.originalClass;
    }

    public void setOriginalClass(Class originalClass) {
        this.originalClass = originalClass;
    }

    public byte[] getTransformed() {
        return this.transformed;
    }

    public void setTransformed(byte[] transformed) {
        this.transformed = transformed;
    }

    public boolean isCanTransform() {
        return this.canTransform;
    }

    public void setCanTransform(boolean canTransform) {
        this.canTransform = canTransform;
    }

    public void addMethod(String name, String description) {
        MethodDescription methodDescription = new MethodDescription(this.getClassName(), name, description);
        this.allMethods.putIfAbsent(methodDescription.getMethodSignature(), methodDescription);
    }

    public String addTransformedMethod(String name, String description) {
        String key = MethodDescription.getMethodSignature(name, description);
        MethodDescription methodDescription = (MethodDescription)this.allMethods.get(key);
        assert (methodDescription != null);
        this.transformedMethods.putIfAbsent(key, methodDescription);
        return key;
    }

    public void removeTransformedMethod(String fullMethodName) {
        this.transformedMethods.remove(fullMethodName);
    }

    public Set<String> getAllMethodNames() {
        HashSet<String> set = new HashSet<String>();
        for (MethodDescription methodDescription : this.allMethods.values()) {
            set.add(methodDescription.getMethodName());
        }
        return set;
    }

    public Set<String> getAllTransformedMethodNames() {
        HashSet<String> set = new HashSet<String>();
        for (MethodDescription methodDescription : this.transformedMethods.values()) {
            set.add(methodDescription.getMethodName());
        }
        return set;
    }

    public Collection<MethodDescription> getTransformedMethodDescriptions() {
        ArrayList<MethodDescription> result = new ArrayList<MethodDescription>();
        result.addAll(this.transformedMethods.values());
        return result;
    }

    public boolean isTransformed() {
        return this.transformed != null && this.transformed.length > 0;
    }

    public void resetTransformed() {
        this.transformed = null;
        this.transformedMethods.clear();
    }
}

