/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ParsedUri {
    private Map<String, String[]> parameters;
    private String pathInfo;
    private URI uri;

    public ParsedUri(URI pUri, String ... pContext) {
        this.uri = pUri;
        this.pathInfo = pUri.getPath();
        if (pContext != null && pContext.length > 0 && this.pathInfo.startsWith(pContext[0])) {
            this.pathInfo = this.pathInfo.substring(pContext[0].length());
        }
        while (this.pathInfo.startsWith("/") && this.pathInfo.length() > 1) {
            this.pathInfo = this.pathInfo.substring(1);
        }
        this.parameters = pUri.getQuery() != null ? this.parseQuery(pUri.getQuery()) : new HashMap<String, String[]>();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    private Map<String, String[]> parseQuery(String qs) {
        TreeMap<String, String[]> ret = new TreeMap<String, String[]>();
        try {
            String[] pairs;
            for (String pair : pairs = qs.split("&")) {
                String value;
                String name;
                int pos = pair.indexOf(61);
                if (pos == -1) {
                    name = pair;
                    value = null;
                } else {
                    name = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
                }
                String[] values = (String[])ret.get(name);
                if (values == null) {
                    values = new String[]{value};
                    ret.put(name, values);
                    continue;
                }
                String[] newValues = new String[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = value;
                ret.put(name, newValues);
            }
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot decode to UTF-8. Should not happen, though.", e);
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

