/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import io.fabric8.apmagent.metrics.ApmAgentContext;
import io.fabric8.apmagent.metrics.MethodMetrics;
import io.fabric8.apmagent.metrics.MethodMetricsProxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MonitoredMethodMetrics {
    protected final ApmAgentContext apmAgentContext;
    private int monitorSize;
    private final List<MethodMetricsProxy> proxyList = new CopyOnWriteArrayList<MethodMetricsProxy>();

    MonitoredMethodMetrics(ApmAgentContext apmAgentContext) {
        this.apmAgentContext = apmAgentContext;
    }

    public int getMonitorSize() {
        return this.monitorSize;
    }

    public synchronized void setMonitorSize(int monitorSize) {
        this.monitorSize = monitorSize;
        while (this.proxyList.size() > monitorSize) {
            MethodMetricsProxy methodMetricsProxy = this.proxyList.get(this.proxyList.size() - 1);
            this.proxyList.remove(this.proxyList.size() - 1);
            this.apmAgentContext.unregisterMethodMetricsMBean(methodMetricsProxy);
        }
    }

    public void calculateMethodMetrics(List<? extends MethodMetrics> methodMetricsList) {
        int extra;
        if (methodMetricsList.size() < this.proxyList.size()) {
            this.setMonitorSize(methodMetricsList.size());
        }
        if (methodMetricsList.size() > this.proxyList.size() && this.proxyList.size() < this.monitorSize && (extra = this.monitorSize - this.proxyList.size()) > 0) {
            for (int i = 0; i < extra; ++i) {
                this.proxyList.add(this.createProxy(this.proxyList.size()));
            }
        }
        for (int i = 0; i < methodMetricsList.size() && i < this.proxyList.size(); ++i) {
            MethodMetricsProxy methodMetricsProxy = this.proxyList.get(i);
            if (methodMetricsProxy == null) continue;
            methodMetricsProxy.setMethodMetrics(methodMetricsList.get(i));
        }
    }

    protected MethodMetricsProxy createProxy(int rank) {
        MethodMetricsProxy result = new MethodMetricsProxy();
        this.apmAgentContext.registerMethodMetricsMBean(rank, result);
        return result;
    }

    protected void destroy() {
        for (MethodMetricsProxy methodMetricsProxy : this.proxyList) {
            this.apmAgentContext.unregisterMethodMetricsMBean(methodMetricsProxy);
        }
        this.proxyList.clear();
    }
}

