/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.spring;

import java.io.File;
import java.net.InetSocketAddress;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ZKServerFactoryBean
implements FactoryBean<ZooKeeperServer>,
InitializingBean,
DisposableBean {
    private ZooKeeperServer zooKeeperServer = new ZooKeeperServer();
    private NIOServerCnxnFactory connectionFactory;
    private File dataLogDir;
    private File dataDir;
    private boolean purge;
    protected int tickTime = 3000;
    private int minSessionTimeout = -1;
    private int maxSessionTimeout = -1;
    private InetSocketAddress clientPortAddress;
    private int maxClientConnections;
    private int port = 2181;

    public ZooKeeperServer getObject() throws Exception {
        return this.zooKeeperServer;
    }

    public Class<ZooKeeperServer> getObjectType() {
        return ZooKeeperServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.purge) {
            this.deleteFilesInDir(this.getDataLogDir());
            this.deleteFilesInDir(this.getDataDir());
        }
        FileTxnSnapLog ftxn = new FileTxnSnapLog(this.getDataLogDir(), this.getDataDir());
        this.zooKeeperServer.setTxnLogFactory(ftxn);
        this.zooKeeperServer.setTickTime(this.getTickTime());
        this.zooKeeperServer.setMinSessionTimeout(this.getMinSessionTimeout());
        this.zooKeeperServer.setMaxSessionTimeout(this.getMaxSessionTimeout());
        this.connectionFactory = new NIOServerCnxnFactory();
        this.connectionFactory.configure(this.getClientPortAddress(), this.getMaxClientConnections());
        this.connectionFactory.startup(this.zooKeeperServer);
    }

    private void deleteFilesInDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFilesInDir(file);
                    continue;
                }
                file.delete();
            }
        }
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    protected void shutdown() {
        if (this.connectionFactory != null) {
            this.connectionFactory.shutdown();
            try {
                this.connectionFactory.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connectionFactory = null;
        }
        if (this.zooKeeperServer != null) {
            this.zooKeeperServer.shutdown();
            this.zooKeeperServer = null;
        }
    }

    public ZooKeeperServer getZooKeeperServer() {
        return this.zooKeeperServer;
    }

    public NIOServerCnxnFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public File getDataLogDir() {
        if (this.dataLogDir == null) {
            this.dataLogDir = new File(this.getZKOutputDir(), "log");
            this.dataLogDir.mkdirs();
        }
        return this.dataLogDir;
    }

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(this.getZKOutputDir(), "data");
            this.dataDir.mkdirs();
        }
        return this.dataDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getClientPortAddress() {
        if (this.clientPortAddress == null) {
            this.clientPortAddress = new InetSocketAddress(this.port);
        }
        return this.clientPortAddress;
    }

    public int getMaxClientConnections() {
        return this.maxClientConnections;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClientPortAddress(InetSocketAddress clientPortAddress) {
        this.clientPortAddress = clientPortAddress;
    }

    public void setConnectionFactory(NIOServerCnxnFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setDataLogDir(File dataLogDir) {
        this.dataLogDir = dataLogDir;
    }

    public void setMaxClientConnections(int maxClientConnections) {
        this.maxClientConnections = maxClientConnections;
    }

    public void setMaxSessionTimeout(int maxSessionTimeout) {
        this.maxSessionTimeout = maxSessionTimeout;
    }

    public void setMinSessionTimeout(int minSessionTimeout) {
        this.minSessionTimeout = minSessionTimeout;
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public void setZooKeeperServer(ZooKeeperServer zooKeeperServer) {
        this.zooKeeperServer = zooKeeperServer;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    protected File getZKOutputDir() {
        String baseDir = System.getProperty("basedir", ".");
        File dir = new File(baseDir + "/target/zk");
        dir.mkdirs();
        return dir;
    }
}

